/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Completion {

    /**
     * The ID associated with this completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The external reference associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("external_reference")
    @Deprecated
    private JsonNullable<String> externalReference;

    /**
     * The result of the completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("result")
    private JsonNullable<? extends CompletionResult1> result;

    /**
     * The date the content was completed
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("completed_at")
    private JsonNullable<String> completedAt;

    /**
     * The created date of the completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<String> createdAt;

    /**
     * The updated date of the completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<String> updatedAt;

    /**
     * The learning object type of the completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_type")
    private JsonNullable<? extends CompletionLearningObjectType> learningObjectType;

    /**
     * The id of the learning object associated with this completion. This is not required unless specified in an integration.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_id")
    private JsonNullable<String> learningObjectId;

    /**
     * Provider's unique identifier of the learning object related to the completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_learning_object_id")
    private JsonNullable<String> remoteLearningObjectId;

    /**
     * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_external_reference")
    private JsonNullable<String> learningObjectExternalReference;

    /**
     * The user ID associated with this completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("user_id")
    private JsonNullable<String> userId;

    /**
     * Provider's unique identifier of the user related to the completion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_user_id")
    private JsonNullable<String> remoteUserId;

    /**
     * The external ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("external_id")
    @Deprecated
    private JsonNullable<String> externalId;

    /**
     * The external reference associated with this content
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_external_reference")
    @Deprecated
    private JsonNullable<String> contentExternalReference;

    /**
     * Provider's unique identifier of the content external reference
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_external_id")
    @Deprecated
    private JsonNullable<String> remoteExternalId;

    /**
     * The content ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_id")
    @Deprecated
    private JsonNullable<String> contentId;

    /**
     * Provider's unique identifier of the content associated with the completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_content_id")
    @Deprecated
    private JsonNullable<String> remoteContentId;

    /**
     * The course ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("course_id")
    @Deprecated
    private JsonNullable<String> courseId;

    /**
     * Provider's unique identifier of the course associated with the completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_course_id")
    @Deprecated
    private JsonNullable<String> remoteCourseId;

    @JsonCreator
    public Completion(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("external_reference") JsonNullable<String> externalReference,
            @JsonProperty("result") JsonNullable<? extends CompletionResult1> result,
            @JsonProperty("completed_at") JsonNullable<String> completedAt,
            @JsonProperty("created_at") JsonNullable<String> createdAt,
            @JsonProperty("updated_at") JsonNullable<String> updatedAt,
            @JsonProperty("learning_object_type") JsonNullable<? extends CompletionLearningObjectType> learningObjectType,
            @JsonProperty("learning_object_id") JsonNullable<String> learningObjectId,
            @JsonProperty("remote_learning_object_id") JsonNullable<String> remoteLearningObjectId,
            @JsonProperty("learning_object_external_reference") JsonNullable<String> learningObjectExternalReference,
            @JsonProperty("user_id") JsonNullable<String> userId,
            @JsonProperty("remote_user_id") JsonNullable<String> remoteUserId,
            @JsonProperty("external_id") JsonNullable<String> externalId,
            @JsonProperty("content_external_reference") JsonNullable<String> contentExternalReference,
            @JsonProperty("remote_external_id") JsonNullable<String> remoteExternalId,
            @JsonProperty("content_id") JsonNullable<String> contentId,
            @JsonProperty("remote_content_id") JsonNullable<String> remoteContentId,
            @JsonProperty("course_id") JsonNullable<String> courseId,
            @JsonProperty("remote_course_id") JsonNullable<String> remoteCourseId) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(externalReference, "externalReference");
        Utils.checkNotNull(result, "result");
        Utils.checkNotNull(completedAt, "completedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(learningObjectType, "learningObjectType");
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        Utils.checkNotNull(externalId, "externalId");
        Utils.checkNotNull(contentExternalReference, "contentExternalReference");
        Utils.checkNotNull(remoteExternalId, "remoteExternalId");
        Utils.checkNotNull(contentId, "contentId");
        Utils.checkNotNull(remoteContentId, "remoteContentId");
        Utils.checkNotNull(courseId, "courseId");
        Utils.checkNotNull(remoteCourseId, "remoteCourseId");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.externalReference = externalReference;
        this.result = result;
        this.completedAt = completedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.learningObjectType = learningObjectType;
        this.learningObjectId = learningObjectId;
        this.remoteLearningObjectId = remoteLearningObjectId;
        this.learningObjectExternalReference = learningObjectExternalReference;
        this.userId = userId;
        this.remoteUserId = remoteUserId;
        this.externalId = externalId;
        this.contentExternalReference = contentExternalReference;
        this.remoteExternalId = remoteExternalId;
        this.contentId = contentId;
        this.remoteContentId = remoteContentId;
        this.courseId = courseId;
        this.remoteCourseId = remoteCourseId;
    }
    
    public Completion() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The ID associated with this completion
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The external reference associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    /**
     * The result of the completion
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CompletionResult1> result() {
        return (JsonNullable<CompletionResult1>) result;
    }

    /**
     * The date the content was completed
     */
    @JsonIgnore
    public JsonNullable<String> completedAt() {
        return completedAt;
    }

    /**
     * The created date of the completion
     */
    @JsonIgnore
    public JsonNullable<String> createdAt() {
        return createdAt;
    }

    /**
     * The updated date of the completion
     */
    @JsonIgnore
    public JsonNullable<String> updatedAt() {
        return updatedAt;
    }

    /**
     * The learning object type of the completion
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CompletionLearningObjectType> learningObjectType() {
        return (JsonNullable<CompletionLearningObjectType>) learningObjectType;
    }

    /**
     * The id of the learning object associated with this completion. This is not required unless specified in an integration.
     */
    @JsonIgnore
    public JsonNullable<String> learningObjectId() {
        return learningObjectId;
    }

    /**
     * Provider's unique identifier of the learning object related to the completion
     */
    @JsonIgnore
    public JsonNullable<String> remoteLearningObjectId() {
        return remoteLearningObjectId;
    }

    /**
     * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
     */
    @JsonIgnore
    public JsonNullable<String> learningObjectExternalReference() {
        return learningObjectExternalReference;
    }

    /**
     * The user ID associated with this completion
     */
    @JsonIgnore
    public JsonNullable<String> userId() {
        return userId;
    }

    /**
     * Provider's unique identifier of the user related to the completion
     */
    @JsonIgnore
    public JsonNullable<String> remoteUserId() {
        return remoteUserId;
    }

    /**
     * The external ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> externalId() {
        return externalId;
    }

    /**
     * The external reference associated with this content
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> contentExternalReference() {
        return contentExternalReference;
    }

    /**
     * Provider's unique identifier of the content external reference
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> remoteExternalId() {
        return remoteExternalId;
    }

    /**
     * The content ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> contentId() {
        return contentId;
    }

    /**
     * Provider's unique identifier of the content associated with the completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> remoteContentId() {
        return remoteContentId;
    }

    /**
     * The course ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> courseId() {
        return courseId;
    }

    /**
     * Provider's unique identifier of the course associated with the completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> remoteCourseId() {
        return remoteCourseId;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The ID associated with this completion
     */
    public Completion withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The ID associated with this completion
     */
    public Completion withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Completion withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Completion withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Completion withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Completion withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The external reference associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * The external reference associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }

    /**
     * The result of the completion
     */
    public Completion withResult(CompletionResult1 result) {
        Utils.checkNotNull(result, "result");
        this.result = JsonNullable.of(result);
        return this;
    }

    /**
     * The result of the completion
     */
    public Completion withResult(JsonNullable<? extends CompletionResult1> result) {
        Utils.checkNotNull(result, "result");
        this.result = result;
        return this;
    }

    /**
     * The date the content was completed
     */
    public Completion withCompletedAt(String completedAt) {
        Utils.checkNotNull(completedAt, "completedAt");
        this.completedAt = JsonNullable.of(completedAt);
        return this;
    }

    /**
     * The date the content was completed
     */
    public Completion withCompletedAt(JsonNullable<String> completedAt) {
        Utils.checkNotNull(completedAt, "completedAt");
        this.completedAt = completedAt;
        return this;
    }

    /**
     * The created date of the completion
     */
    public Completion withCreatedAt(String createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The created date of the completion
     */
    public Completion withCreatedAt(JsonNullable<String> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The updated date of the completion
     */
    public Completion withUpdatedAt(String updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The updated date of the completion
     */
    public Completion withUpdatedAt(JsonNullable<String> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * The learning object type of the completion
     */
    public Completion withLearningObjectType(CompletionLearningObjectType learningObjectType) {
        Utils.checkNotNull(learningObjectType, "learningObjectType");
        this.learningObjectType = JsonNullable.of(learningObjectType);
        return this;
    }

    /**
     * The learning object type of the completion
     */
    public Completion withLearningObjectType(JsonNullable<? extends CompletionLearningObjectType> learningObjectType) {
        Utils.checkNotNull(learningObjectType, "learningObjectType");
        this.learningObjectType = learningObjectType;
        return this;
    }

    /**
     * The id of the learning object associated with this completion. This is not required unless specified in an integration.
     */
    public Completion withLearningObjectId(String learningObjectId) {
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        this.learningObjectId = JsonNullable.of(learningObjectId);
        return this;
    }

    /**
     * The id of the learning object associated with this completion. This is not required unless specified in an integration.
     */
    public Completion withLearningObjectId(JsonNullable<String> learningObjectId) {
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        this.learningObjectId = learningObjectId;
        return this;
    }

    /**
     * Provider's unique identifier of the learning object related to the completion
     */
    public Completion withRemoteLearningObjectId(String remoteLearningObjectId) {
        Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
        this.remoteLearningObjectId = JsonNullable.of(remoteLearningObjectId);
        return this;
    }

    /**
     * Provider's unique identifier of the learning object related to the completion
     */
    public Completion withRemoteLearningObjectId(JsonNullable<String> remoteLearningObjectId) {
        Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
        this.remoteLearningObjectId = remoteLearningObjectId;
        return this;
    }

    /**
     * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
     */
    public Completion withLearningObjectExternalReference(String learningObjectExternalReference) {
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        this.learningObjectExternalReference = JsonNullable.of(learningObjectExternalReference);
        return this;
    }

    /**
     * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
     */
    public Completion withLearningObjectExternalReference(JsonNullable<String> learningObjectExternalReference) {
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        this.learningObjectExternalReference = learningObjectExternalReference;
        return this;
    }

    /**
     * The user ID associated with this completion
     */
    public Completion withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = JsonNullable.of(userId);
        return this;
    }

    /**
     * The user ID associated with this completion
     */
    public Completion withUserId(JsonNullable<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    /**
     * Provider's unique identifier of the user related to the completion
     */
    public Completion withRemoteUserId(String remoteUserId) {
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        this.remoteUserId = JsonNullable.of(remoteUserId);
        return this;
    }

    /**
     * Provider's unique identifier of the user related to the completion
     */
    public Completion withRemoteUserId(JsonNullable<String> remoteUserId) {
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        this.remoteUserId = remoteUserId;
        return this;
    }

    /**
     * The external ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withExternalId(String externalId) {
        Utils.checkNotNull(externalId, "externalId");
        this.externalId = JsonNullable.of(externalId);
        return this;
    }

    /**
     * The external ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withExternalId(JsonNullable<String> externalId) {
        Utils.checkNotNull(externalId, "externalId");
        this.externalId = externalId;
        return this;
    }

    /**
     * The external reference associated with this content
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withContentExternalReference(String contentExternalReference) {
        Utils.checkNotNull(contentExternalReference, "contentExternalReference");
        this.contentExternalReference = JsonNullable.of(contentExternalReference);
        return this;
    }

    /**
     * The external reference associated with this content
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withContentExternalReference(JsonNullable<String> contentExternalReference) {
        Utils.checkNotNull(contentExternalReference, "contentExternalReference");
        this.contentExternalReference = contentExternalReference;
        return this;
    }

    /**
     * Provider's unique identifier of the content external reference
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withRemoteExternalId(String remoteExternalId) {
        Utils.checkNotNull(remoteExternalId, "remoteExternalId");
        this.remoteExternalId = JsonNullable.of(remoteExternalId);
        return this;
    }

    /**
     * Provider's unique identifier of the content external reference
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withRemoteExternalId(JsonNullable<String> remoteExternalId) {
        Utils.checkNotNull(remoteExternalId, "remoteExternalId");
        this.remoteExternalId = remoteExternalId;
        return this;
    }

    /**
     * The content ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withContentId(String contentId) {
        Utils.checkNotNull(contentId, "contentId");
        this.contentId = JsonNullable.of(contentId);
        return this;
    }

    /**
     * The content ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withContentId(JsonNullable<String> contentId) {
        Utils.checkNotNull(contentId, "contentId");
        this.contentId = contentId;
        return this;
    }

    /**
     * Provider's unique identifier of the content associated with the completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withRemoteContentId(String remoteContentId) {
        Utils.checkNotNull(remoteContentId, "remoteContentId");
        this.remoteContentId = JsonNullable.of(remoteContentId);
        return this;
    }

    /**
     * Provider's unique identifier of the content associated with the completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withRemoteContentId(JsonNullable<String> remoteContentId) {
        Utils.checkNotNull(remoteContentId, "remoteContentId");
        this.remoteContentId = remoteContentId;
        return this;
    }

    /**
     * The course ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withCourseId(String courseId) {
        Utils.checkNotNull(courseId, "courseId");
        this.courseId = JsonNullable.of(courseId);
        return this;
    }

    /**
     * The course ID associated with this completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withCourseId(JsonNullable<String> courseId) {
        Utils.checkNotNull(courseId, "courseId");
        this.courseId = courseId;
        return this;
    }

    /**
     * Provider's unique identifier of the course associated with the completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withRemoteCourseId(String remoteCourseId) {
        Utils.checkNotNull(remoteCourseId, "remoteCourseId");
        this.remoteCourseId = JsonNullable.of(remoteCourseId);
        return this;
    }

    /**
     * Provider's unique identifier of the course associated with the completion
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Completion withRemoteCourseId(JsonNullable<String> remoteCourseId) {
        Utils.checkNotNull(remoteCourseId, "remoteCourseId");
        this.remoteCourseId = remoteCourseId;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Completion other = (Completion) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Objects.deepEquals(this.externalReference, other.externalReference) &&
            Objects.deepEquals(this.result, other.result) &&
            Objects.deepEquals(this.completedAt, other.completedAt) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt) &&
            Objects.deepEquals(this.learningObjectType, other.learningObjectType) &&
            Objects.deepEquals(this.learningObjectId, other.learningObjectId) &&
            Objects.deepEquals(this.remoteLearningObjectId, other.remoteLearningObjectId) &&
            Objects.deepEquals(this.learningObjectExternalReference, other.learningObjectExternalReference) &&
            Objects.deepEquals(this.userId, other.userId) &&
            Objects.deepEquals(this.remoteUserId, other.remoteUserId) &&
            Objects.deepEquals(this.externalId, other.externalId) &&
            Objects.deepEquals(this.contentExternalReference, other.contentExternalReference) &&
            Objects.deepEquals(this.remoteExternalId, other.remoteExternalId) &&
            Objects.deepEquals(this.contentId, other.contentId) &&
            Objects.deepEquals(this.remoteContentId, other.remoteContentId) &&
            Objects.deepEquals(this.courseId, other.courseId) &&
            Objects.deepEquals(this.remoteCourseId, other.remoteCourseId);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            unifiedCustomFields,
            externalReference,
            result,
            completedAt,
            createdAt,
            updatedAt,
            learningObjectType,
            learningObjectId,
            remoteLearningObjectId,
            learningObjectExternalReference,
            userId,
            remoteUserId,
            externalId,
            contentExternalReference,
            remoteExternalId,
            contentId,
            remoteContentId,
            courseId,
            remoteCourseId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Completion.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "externalReference", externalReference,
                "result", result,
                "completedAt", completedAt,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "learningObjectType", learningObjectType,
                "learningObjectId", learningObjectId,
                "remoteLearningObjectId", remoteLearningObjectId,
                "learningObjectExternalReference", learningObjectExternalReference,
                "userId", userId,
                "remoteUserId", remoteUserId,
                "externalId", externalId,
                "contentExternalReference", contentExternalReference,
                "remoteExternalId", remoteExternalId,
                "contentId", contentId,
                "remoteContentId", remoteContentId,
                "courseId", courseId,
                "remoteCourseId", remoteCourseId);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> externalReference = JsonNullable.undefined();
 
        private JsonNullable<? extends CompletionResult1> result = JsonNullable.undefined();
 
        private JsonNullable<String> completedAt = JsonNullable.undefined();
 
        private JsonNullable<String> createdAt = JsonNullable.undefined();
 
        private JsonNullable<String> updatedAt = JsonNullable.undefined();
 
        private JsonNullable<? extends CompletionLearningObjectType> learningObjectType = JsonNullable.undefined();
 
        private JsonNullable<String> learningObjectId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteLearningObjectId = JsonNullable.undefined();
 
        private JsonNullable<String> learningObjectExternalReference = JsonNullable.undefined();
 
        private JsonNullable<String> userId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteUserId = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> externalId = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> contentExternalReference = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> remoteExternalId = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> contentId = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> remoteContentId = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> courseId = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> remoteCourseId = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The ID associated with this completion
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The ID associated with this completion
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * The external reference associated with this completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * The external reference associated with this completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }

        /**
         * The result of the completion
         */
        public Builder result(CompletionResult1 result) {
            Utils.checkNotNull(result, "result");
            this.result = JsonNullable.of(result);
            return this;
        }

        /**
         * The result of the completion
         */
        public Builder result(JsonNullable<? extends CompletionResult1> result) {
            Utils.checkNotNull(result, "result");
            this.result = result;
            return this;
        }

        /**
         * The date the content was completed
         */
        public Builder completedAt(String completedAt) {
            Utils.checkNotNull(completedAt, "completedAt");
            this.completedAt = JsonNullable.of(completedAt);
            return this;
        }

        /**
         * The date the content was completed
         */
        public Builder completedAt(JsonNullable<String> completedAt) {
            Utils.checkNotNull(completedAt, "completedAt");
            this.completedAt = completedAt;
            return this;
        }

        /**
         * The created date of the completion
         */
        public Builder createdAt(String createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The created date of the completion
         */
        public Builder createdAt(JsonNullable<String> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The updated date of the completion
         */
        public Builder updatedAt(String updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The updated date of the completion
         */
        public Builder updatedAt(JsonNullable<String> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * The learning object type of the completion
         */
        public Builder learningObjectType(CompletionLearningObjectType learningObjectType) {
            Utils.checkNotNull(learningObjectType, "learningObjectType");
            this.learningObjectType = JsonNullable.of(learningObjectType);
            return this;
        }

        /**
         * The learning object type of the completion
         */
        public Builder learningObjectType(JsonNullable<? extends CompletionLearningObjectType> learningObjectType) {
            Utils.checkNotNull(learningObjectType, "learningObjectType");
            this.learningObjectType = learningObjectType;
            return this;
        }

        /**
         * The id of the learning object associated with this completion. This is not required unless specified in an integration.
         */
        public Builder learningObjectId(String learningObjectId) {
            Utils.checkNotNull(learningObjectId, "learningObjectId");
            this.learningObjectId = JsonNullable.of(learningObjectId);
            return this;
        }

        /**
         * The id of the learning object associated with this completion. This is not required unless specified in an integration.
         */
        public Builder learningObjectId(JsonNullable<String> learningObjectId) {
            Utils.checkNotNull(learningObjectId, "learningObjectId");
            this.learningObjectId = learningObjectId;
            return this;
        }

        /**
         * Provider's unique identifier of the learning object related to the completion
         */
        public Builder remoteLearningObjectId(String remoteLearningObjectId) {
            Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
            this.remoteLearningObjectId = JsonNullable.of(remoteLearningObjectId);
            return this;
        }

        /**
         * Provider's unique identifier of the learning object related to the completion
         */
        public Builder remoteLearningObjectId(JsonNullable<String> remoteLearningObjectId) {
            Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
            this.remoteLearningObjectId = remoteLearningObjectId;
            return this;
        }

        /**
         * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
         */
        public Builder learningObjectExternalReference(String learningObjectExternalReference) {
            Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
            this.learningObjectExternalReference = JsonNullable.of(learningObjectExternalReference);
            return this;
        }

        /**
         * The external reference of the learning object associated with this completion, this is the main identifier for creating completions.
         */
        public Builder learningObjectExternalReference(JsonNullable<String> learningObjectExternalReference) {
            Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
            this.learningObjectExternalReference = learningObjectExternalReference;
            return this;
        }

        /**
         * The user ID associated with this completion
         */
        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = JsonNullable.of(userId);
            return this;
        }

        /**
         * The user ID associated with this completion
         */
        public Builder userId(JsonNullable<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        /**
         * Provider's unique identifier of the user related to the completion
         */
        public Builder remoteUserId(String remoteUserId) {
            Utils.checkNotNull(remoteUserId, "remoteUserId");
            this.remoteUserId = JsonNullable.of(remoteUserId);
            return this;
        }

        /**
         * Provider's unique identifier of the user related to the completion
         */
        public Builder remoteUserId(JsonNullable<String> remoteUserId) {
            Utils.checkNotNull(remoteUserId, "remoteUserId");
            this.remoteUserId = remoteUserId;
            return this;
        }

        /**
         * The external ID associated with this completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder externalId(String externalId) {
            Utils.checkNotNull(externalId, "externalId");
            this.externalId = JsonNullable.of(externalId);
            return this;
        }

        /**
         * The external ID associated with this completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder externalId(JsonNullable<String> externalId) {
            Utils.checkNotNull(externalId, "externalId");
            this.externalId = externalId;
            return this;
        }

        /**
         * The external reference associated with this content
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contentExternalReference(String contentExternalReference) {
            Utils.checkNotNull(contentExternalReference, "contentExternalReference");
            this.contentExternalReference = JsonNullable.of(contentExternalReference);
            return this;
        }

        /**
         * The external reference associated with this content
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contentExternalReference(JsonNullable<String> contentExternalReference) {
            Utils.checkNotNull(contentExternalReference, "contentExternalReference");
            this.contentExternalReference = contentExternalReference;
            return this;
        }

        /**
         * Provider's unique identifier of the content external reference
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder remoteExternalId(String remoteExternalId) {
            Utils.checkNotNull(remoteExternalId, "remoteExternalId");
            this.remoteExternalId = JsonNullable.of(remoteExternalId);
            return this;
        }

        /**
         * Provider's unique identifier of the content external reference
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder remoteExternalId(JsonNullable<String> remoteExternalId) {
            Utils.checkNotNull(remoteExternalId, "remoteExternalId");
            this.remoteExternalId = remoteExternalId;
            return this;
        }

        /**
         * The content ID associated with this completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contentId(String contentId) {
            Utils.checkNotNull(contentId, "contentId");
            this.contentId = JsonNullable.of(contentId);
            return this;
        }

        /**
         * The content ID associated with this completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder contentId(JsonNullable<String> contentId) {
            Utils.checkNotNull(contentId, "contentId");
            this.contentId = contentId;
            return this;
        }

        /**
         * Provider's unique identifier of the content associated with the completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder remoteContentId(String remoteContentId) {
            Utils.checkNotNull(remoteContentId, "remoteContentId");
            this.remoteContentId = JsonNullable.of(remoteContentId);
            return this;
        }

        /**
         * Provider's unique identifier of the content associated with the completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder remoteContentId(JsonNullable<String> remoteContentId) {
            Utils.checkNotNull(remoteContentId, "remoteContentId");
            this.remoteContentId = remoteContentId;
            return this;
        }

        /**
         * The course ID associated with this completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder courseId(String courseId) {
            Utils.checkNotNull(courseId, "courseId");
            this.courseId = JsonNullable.of(courseId);
            return this;
        }

        /**
         * The course ID associated with this completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder courseId(JsonNullable<String> courseId) {
            Utils.checkNotNull(courseId, "courseId");
            this.courseId = courseId;
            return this;
        }

        /**
         * Provider's unique identifier of the course associated with the completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder remoteCourseId(String remoteCourseId) {
            Utils.checkNotNull(remoteCourseId, "remoteCourseId");
            this.remoteCourseId = JsonNullable.of(remoteCourseId);
            return this;
        }

        /**
         * Provider's unique identifier of the course associated with the completion
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder remoteCourseId(JsonNullable<String> remoteCourseId) {
            Utils.checkNotNull(remoteCourseId, "remoteCourseId");
            this.remoteCourseId = remoteCourseId;
            return this;
        }
        
        public Completion build() {
            return new Completion(
                id,
                remoteId,
                unifiedCustomFields,
                externalReference,
                result,
                completedAt,
                createdAt,
                updatedAt,
                learningObjectType,
                learningObjectId,
                remoteLearningObjectId,
                learningObjectExternalReference,
                userId,
                remoteUserId,
                externalId,
                contentExternalReference,
                remoteExternalId,
                contentId,
                remoteContentId,
                courseId,
                remoteCourseId);
        }
    }
}

