/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class UnifiedUploadRequestDto {

    /**
     * The filename of the file to upload
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The file format of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_format")
    private JsonNullable<? extends UnifiedUploadRequestDtoFileFormat> fileFormat;

    /**
     * The base64 encoded content of the file to upload
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content")
    private JsonNullable<String> content;

    /**
     * The categoryId of the documents
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("category_id")
    private JsonNullable<String> categoryId;

    /**
     * The path for the file to be uploaded to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path")
    private JsonNullable<String> path;

    /**
     * The category object for associating uploaded files. If both an ID and a name are provided, the ID takes precedence.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("category")
    private JsonNullable<? extends UnifiedUploadRequestDtoCategory> category;

    /**
     * The confidentiality level of the file to be uploaded
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("confidential")
    private JsonNullable<? extends UnifiedUploadRequestDtoConfidential> confidential;

    @JsonCreator
    public UnifiedUploadRequestDto(
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("file_format") JsonNullable<? extends UnifiedUploadRequestDtoFileFormat> fileFormat,
            @JsonProperty("content") JsonNullable<String> content,
            @JsonProperty("category_id") JsonNullable<String> categoryId,
            @JsonProperty("path") JsonNullable<String> path,
            @JsonProperty("category") JsonNullable<? extends UnifiedUploadRequestDtoCategory> category,
            @JsonProperty("confidential") JsonNullable<? extends UnifiedUploadRequestDtoConfidential> confidential) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(fileFormat, "fileFormat");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(categoryId, "categoryId");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(category, "category");
        Utils.checkNotNull(confidential, "confidential");
        this.name = name;
        this.fileFormat = fileFormat;
        this.content = content;
        this.categoryId = categoryId;
        this.path = path;
        this.category = category;
        this.confidential = confidential;
    }
    
    public UnifiedUploadRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The filename of the file to upload
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The file format of the file
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<UnifiedUploadRequestDtoFileFormat> fileFormat() {
        return (JsonNullable<UnifiedUploadRequestDtoFileFormat>) fileFormat;
    }

    /**
     * The base64 encoded content of the file to upload
     */
    @JsonIgnore
    public JsonNullable<String> content() {
        return content;
    }

    /**
     * The categoryId of the documents
     */
    @JsonIgnore
    public JsonNullable<String> categoryId() {
        return categoryId;
    }

    /**
     * The path for the file to be uploaded to
     */
    @JsonIgnore
    public JsonNullable<String> path() {
        return path;
    }

    /**
     * The category object for associating uploaded files. If both an ID and a name are provided, the ID takes precedence.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<UnifiedUploadRequestDtoCategory> category() {
        return (JsonNullable<UnifiedUploadRequestDtoCategory>) category;
    }

    /**
     * The confidentiality level of the file to be uploaded
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<UnifiedUploadRequestDtoConfidential> confidential() {
        return (JsonNullable<UnifiedUploadRequestDtoConfidential>) confidential;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The filename of the file to upload
     */
    public UnifiedUploadRequestDto withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The filename of the file to upload
     */
    public UnifiedUploadRequestDto withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The file format of the file
     */
    public UnifiedUploadRequestDto withFileFormat(UnifiedUploadRequestDtoFileFormat fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = JsonNullable.of(fileFormat);
        return this;
    }

    /**
     * The file format of the file
     */
    public UnifiedUploadRequestDto withFileFormat(JsonNullable<? extends UnifiedUploadRequestDtoFileFormat> fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = fileFormat;
        return this;
    }

    /**
     * The base64 encoded content of the file to upload
     */
    public UnifiedUploadRequestDto withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    /**
     * The base64 encoded content of the file to upload
     */
    public UnifiedUploadRequestDto withContent(JsonNullable<String> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * The categoryId of the documents
     */
    public UnifiedUploadRequestDto withCategoryId(String categoryId) {
        Utils.checkNotNull(categoryId, "categoryId");
        this.categoryId = JsonNullable.of(categoryId);
        return this;
    }

    /**
     * The categoryId of the documents
     */
    public UnifiedUploadRequestDto withCategoryId(JsonNullable<String> categoryId) {
        Utils.checkNotNull(categoryId, "categoryId");
        this.categoryId = categoryId;
        return this;
    }

    /**
     * The path for the file to be uploaded to
     */
    public UnifiedUploadRequestDto withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    /**
     * The path for the file to be uploaded to
     */
    public UnifiedUploadRequestDto withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    /**
     * The category object for associating uploaded files. If both an ID and a name are provided, the ID takes precedence.
     */
    public UnifiedUploadRequestDto withCategory(UnifiedUploadRequestDtoCategory category) {
        Utils.checkNotNull(category, "category");
        this.category = JsonNullable.of(category);
        return this;
    }

    /**
     * The category object for associating uploaded files. If both an ID and a name are provided, the ID takes precedence.
     */
    public UnifiedUploadRequestDto withCategory(JsonNullable<? extends UnifiedUploadRequestDtoCategory> category) {
        Utils.checkNotNull(category, "category");
        this.category = category;
        return this;
    }

    /**
     * The confidentiality level of the file to be uploaded
     */
    public UnifiedUploadRequestDto withConfidential(UnifiedUploadRequestDtoConfidential confidential) {
        Utils.checkNotNull(confidential, "confidential");
        this.confidential = JsonNullable.of(confidential);
        return this;
    }

    /**
     * The confidentiality level of the file to be uploaded
     */
    public UnifiedUploadRequestDto withConfidential(JsonNullable<? extends UnifiedUploadRequestDtoConfidential> confidential) {
        Utils.checkNotNull(confidential, "confidential");
        this.confidential = confidential;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnifiedUploadRequestDto other = (UnifiedUploadRequestDto) o;
        return 
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.fileFormat, other.fileFormat) &&
            Objects.deepEquals(this.content, other.content) &&
            Objects.deepEquals(this.categoryId, other.categoryId) &&
            Objects.deepEquals(this.path, other.path) &&
            Objects.deepEquals(this.category, other.category) &&
            Objects.deepEquals(this.confidential, other.confidential);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            name,
            fileFormat,
            content,
            categoryId,
            path,
            category,
            confidential);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UnifiedUploadRequestDto.class,
                "name", name,
                "fileFormat", fileFormat,
                "content", content,
                "categoryId", categoryId,
                "path", path,
                "category", category,
                "confidential", confidential);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<? extends UnifiedUploadRequestDtoFileFormat> fileFormat = JsonNullable.undefined();
 
        private JsonNullable<String> content = JsonNullable.undefined();
 
        private JsonNullable<String> categoryId = JsonNullable.undefined();
 
        private JsonNullable<String> path = JsonNullable.undefined();
 
        private JsonNullable<? extends UnifiedUploadRequestDtoCategory> category = JsonNullable.undefined();
 
        private JsonNullable<? extends UnifiedUploadRequestDtoConfidential> confidential = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The filename of the file to upload
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The filename of the file to upload
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * The file format of the file
         */
        public Builder fileFormat(UnifiedUploadRequestDtoFileFormat fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = JsonNullable.of(fileFormat);
            return this;
        }

        /**
         * The file format of the file
         */
        public Builder fileFormat(JsonNullable<? extends UnifiedUploadRequestDtoFileFormat> fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = fileFormat;
            return this;
        }

        /**
         * The base64 encoded content of the file to upload
         */
        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        /**
         * The base64 encoded content of the file to upload
         */
        public Builder content(JsonNullable<String> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        /**
         * The categoryId of the documents
         */
        public Builder categoryId(String categoryId) {
            Utils.checkNotNull(categoryId, "categoryId");
            this.categoryId = JsonNullable.of(categoryId);
            return this;
        }

        /**
         * The categoryId of the documents
         */
        public Builder categoryId(JsonNullable<String> categoryId) {
            Utils.checkNotNull(categoryId, "categoryId");
            this.categoryId = categoryId;
            return this;
        }

        /**
         * The path for the file to be uploaded to
         */
        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        /**
         * The path for the file to be uploaded to
         */
        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }

        /**
         * The category object for associating uploaded files. If both an ID and a name are provided, the ID takes precedence.
         */
        public Builder category(UnifiedUploadRequestDtoCategory category) {
            Utils.checkNotNull(category, "category");
            this.category = JsonNullable.of(category);
            return this;
        }

        /**
         * The category object for associating uploaded files. If both an ID and a name are provided, the ID takes precedence.
         */
        public Builder category(JsonNullable<? extends UnifiedUploadRequestDtoCategory> category) {
            Utils.checkNotNull(category, "category");
            this.category = category;
            return this;
        }

        /**
         * The confidentiality level of the file to be uploaded
         */
        public Builder confidential(UnifiedUploadRequestDtoConfidential confidential) {
            Utils.checkNotNull(confidential, "confidential");
            this.confidential = JsonNullable.of(confidential);
            return this;
        }

        /**
         * The confidentiality level of the file to be uploaded
         */
        public Builder confidential(JsonNullable<? extends UnifiedUploadRequestDtoConfidential> confidential) {
            Utils.checkNotNull(confidential, "confidential");
            this.confidential = confidential;
            return this;
        }
        
        public UnifiedUploadRequestDto build() {
            return new UnifiedUploadRequestDto(
                name,
                fileFormat,
                content,
                categoryId,
                path,
                category,
                confidential);
        }
    }
}

