/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.IamGroupResult;
import com.stackone.stackone_client_java.models.components.IamGroupsPaginated;
import com.stackone.stackone_client_java.models.components.IamPoliciesPaginated;
import com.stackone.stackone_client_java.models.components.IamPolicyResult;
import com.stackone.stackone_client_java.models.components.IamRoleResult;
import com.stackone.stackone_client_java.models.components.IamRolesPaginated;
import com.stackone.stackone_client_java.models.components.IamUserResult;
import com.stackone.stackone_client_java.models.components.IamUsersPaginated;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.IamGetGroupRequest;
import com.stackone.stackone_client_java.models.operations.IamGetGroupRequestBuilder;
import com.stackone.stackone_client_java.models.operations.IamGetGroupResponse;
import com.stackone.stackone_client_java.models.operations.IamGetPolicyRequest;
import com.stackone.stackone_client_java.models.operations.IamGetPolicyRequestBuilder;
import com.stackone.stackone_client_java.models.operations.IamGetPolicyResponse;
import com.stackone.stackone_client_java.models.operations.IamGetRoleRequest;
import com.stackone.stackone_client_java.models.operations.IamGetRoleRequestBuilder;
import com.stackone.stackone_client_java.models.operations.IamGetRoleResponse;
import com.stackone.stackone_client_java.models.operations.IamGetUserRequest;
import com.stackone.stackone_client_java.models.operations.IamGetUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.IamGetUserResponse;
import com.stackone.stackone_client_java.models.operations.IamListGroupsRequest;
import com.stackone.stackone_client_java.models.operations.IamListGroupsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.IamListGroupsResponse;
import com.stackone.stackone_client_java.models.operations.IamListPoliciesRequest;
import com.stackone.stackone_client_java.models.operations.IamListPoliciesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.IamListPoliciesResponse;
import com.stackone.stackone_client_java.models.operations.IamListRolesRequest;
import com.stackone.stackone_client_java.models.operations.IamListRolesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.IamListRolesResponse;
import com.stackone.stackone_client_java.models.operations.IamListUsersRequest;
import com.stackone.stackone_client_java.models.operations.IamListUsersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.IamListUsersResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Iam
implements SDKMethodInterfaces.MethodCallIamListUsers,
SDKMethodInterfaces.MethodCallIamGetUser,
SDKMethodInterfaces.MethodCallIamListRoles,
SDKMethodInterfaces.MethodCallIamGetRole,
SDKMethodInterfaces.MethodCallIamListGroups,
SDKMethodInterfaces.MethodCallIamGetGroup,
SDKMethodInterfaces.MethodCallIamListPolicies,
SDKMethodInterfaces.MethodCallIamGetPolicy {
    private final SDKConfiguration sdkConfiguration;

    Iam(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public IamListUsersRequestBuilder listUsers() {
        return new IamListUsersRequestBuilder(this);
    }

    public IamListUsersResponse listUsers(IamListUsersRequest request) throws Exception {
        return this.listUsers(request, Optional.empty());
    }

    @Override
    public IamListUsersResponse listUsers(IamListUsersRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/iam/users");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(IamListUsersRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("iam_list_users", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("iam_list_users", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("iam_list_users", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        byte[] _fullResponse = Utils.extractByteArrayFromBody(_httpRes);
        IamListUsersResponse.Builder _resBuilder = IamListUsersResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes).next(() -> {
            String _stringBody = new String(_fullResponse, StandardCharsets.UTF_8);
            DocumentContext _body = JsonPath.parse((String)_stringBody);
            if (request == null) {
                return Optional.empty();
            }
            List _nextCursorToken = (List)_body.read("$.next", List.class, new Predicate[0]);
            if (_nextCursorToken == null || _nextCursorToken.isEmpty()) {
                return Optional.empty();
            }
            String _nextCursor = (String)_nextCursorToken.get(0);
            IamListUsersRequestBuilder _ret = this.listUsers();
            _ret.request(new IamListUsersRequest(request.xAccountId(), request.raw(), request.proxy(), request.fields(), request.filter(), request.page(), request.pageSize(), request.next(), request.updatedAfter(), request.expand()));
            return Optional.of(_ret.call());
        });
        IamListUsersResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                IamUsersPaginated _out = (IamUsersPaginated)Utils.mapper().readValue(new String(_fullResponse, StandardCharsets.UTF_8), (TypeReference)new TypeReference<IamUsersPaginated>(){});
                _res.withIamUsersPaginated(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), _fullResponse);
    }

    public IamGetUserRequestBuilder getUser() {
        return new IamGetUserRequestBuilder(this);
    }

    public IamGetUserResponse getUser(IamGetUserRequest request) throws Exception {
        return this.getUser(request, Optional.empty());
    }

    @Override
    public IamGetUserResponse getUser(IamGetUserRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(IamGetUserRequest.class, _baseUrl, "/unified/iam/users/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(IamGetUserRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("iam_get_user", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("iam_get_user", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("iam_get_user", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        IamGetUserResponse.Builder _resBuilder = IamGetUserResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        IamGetUserResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                IamUserResult _out = (IamUserResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<IamUserResult>(){});
                _res.withIamUserResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public IamListRolesRequestBuilder listRoles() {
        return new IamListRolesRequestBuilder(this);
    }

    public IamListRolesResponse listRoles(IamListRolesRequest request) throws Exception {
        return this.listRoles(request, Optional.empty());
    }

    @Override
    public IamListRolesResponse listRoles(IamListRolesRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/iam/roles");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(IamListRolesRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("iam_list_roles", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("iam_list_roles", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("iam_list_roles", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        byte[] _fullResponse = Utils.extractByteArrayFromBody(_httpRes);
        IamListRolesResponse.Builder _resBuilder = IamListRolesResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes).next(() -> {
            String _stringBody = new String(_fullResponse, StandardCharsets.UTF_8);
            DocumentContext _body = JsonPath.parse((String)_stringBody);
            if (request == null) {
                return Optional.empty();
            }
            List _nextCursorToken = (List)_body.read("$.next", List.class, new Predicate[0]);
            if (_nextCursorToken == null || _nextCursorToken.isEmpty()) {
                return Optional.empty();
            }
            String _nextCursor = (String)_nextCursorToken.get(0);
            IamListRolesRequestBuilder _ret = this.listRoles();
            _ret.request(new IamListRolesRequest(request.xAccountId(), request.raw(), request.proxy(), request.fields(), request.filter(), request.page(), request.pageSize(), request.next(), request.updatedAfter(), request.expand()));
            return Optional.of(_ret.call());
        });
        IamListRolesResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                IamRolesPaginated _out = (IamRolesPaginated)Utils.mapper().readValue(new String(_fullResponse, StandardCharsets.UTF_8), (TypeReference)new TypeReference<IamRolesPaginated>(){});
                _res.withIamRolesPaginated(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), _fullResponse);
    }

    public IamGetRoleRequestBuilder getRole() {
        return new IamGetRoleRequestBuilder(this);
    }

    public IamGetRoleResponse getRole(IamGetRoleRequest request) throws Exception {
        return this.getRole(request, Optional.empty());
    }

    @Override
    public IamGetRoleResponse getRole(IamGetRoleRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(IamGetRoleRequest.class, _baseUrl, "/unified/iam/roles/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(IamGetRoleRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("iam_get_role", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("iam_get_role", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("iam_get_role", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        IamGetRoleResponse.Builder _resBuilder = IamGetRoleResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        IamGetRoleResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                IamRoleResult _out = (IamRoleResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<IamRoleResult>(){});
                _res.withIamRoleResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public IamListGroupsRequestBuilder listGroups() {
        return new IamListGroupsRequestBuilder(this);
    }

    public IamListGroupsResponse listGroups(IamListGroupsRequest request) throws Exception {
        return this.listGroups(request, Optional.empty());
    }

    @Override
    public IamListGroupsResponse listGroups(IamListGroupsRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/iam/groups");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(IamListGroupsRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("iam_list_groups", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("iam_list_groups", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("iam_list_groups", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        byte[] _fullResponse = Utils.extractByteArrayFromBody(_httpRes);
        IamListGroupsResponse.Builder _resBuilder = IamListGroupsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes).next(() -> {
            String _stringBody = new String(_fullResponse, StandardCharsets.UTF_8);
            DocumentContext _body = JsonPath.parse((String)_stringBody);
            if (request == null) {
                return Optional.empty();
            }
            List _nextCursorToken = (List)_body.read("$.next", List.class, new Predicate[0]);
            if (_nextCursorToken == null || _nextCursorToken.isEmpty()) {
                return Optional.empty();
            }
            String _nextCursor = (String)_nextCursorToken.get(0);
            IamListGroupsRequestBuilder _ret = this.listGroups();
            _ret.request(new IamListGroupsRequest(request.xAccountId(), request.raw(), request.proxy(), request.fields(), request.filter(), request.page(), request.pageSize(), request.next(), request.updatedAfter(), request.expand()));
            return Optional.of(_ret.call());
        });
        IamListGroupsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                IamGroupsPaginated _out = (IamGroupsPaginated)Utils.mapper().readValue(new String(_fullResponse, StandardCharsets.UTF_8), (TypeReference)new TypeReference<IamGroupsPaginated>(){});
                _res.withIamGroupsPaginated(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), _fullResponse);
    }

    public IamGetGroupRequestBuilder getGroup() {
        return new IamGetGroupRequestBuilder(this);
    }

    public IamGetGroupResponse getGroup(IamGetGroupRequest request) throws Exception {
        return this.getGroup(request, Optional.empty());
    }

    @Override
    public IamGetGroupResponse getGroup(IamGetGroupRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(IamGetGroupRequest.class, _baseUrl, "/unified/iam/groups/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(IamGetGroupRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("iam_get_group", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("iam_get_group", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("iam_get_group", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        IamGetGroupResponse.Builder _resBuilder = IamGetGroupResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        IamGetGroupResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                IamGroupResult _out = (IamGroupResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<IamGroupResult>(){});
                _res.withIamGroupResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public IamListPoliciesRequestBuilder listPolicies() {
        return new IamListPoliciesRequestBuilder(this);
    }

    public IamListPoliciesResponse listPolicies(IamListPoliciesRequest request) throws Exception {
        return this.listPolicies(request, Optional.empty());
    }

    @Override
    public IamListPoliciesResponse listPolicies(IamListPoliciesRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/iam/policies");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(IamListPoliciesRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("iam_list_policies", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("iam_list_policies", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("iam_list_policies", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        byte[] _fullResponse = Utils.extractByteArrayFromBody(_httpRes);
        IamListPoliciesResponse.Builder _resBuilder = IamListPoliciesResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes).next(() -> {
            String _stringBody = new String(_fullResponse, StandardCharsets.UTF_8);
            DocumentContext _body = JsonPath.parse((String)_stringBody);
            if (request == null) {
                return Optional.empty();
            }
            List _nextCursorToken = (List)_body.read("$.next", List.class, new Predicate[0]);
            if (_nextCursorToken == null || _nextCursorToken.isEmpty()) {
                return Optional.empty();
            }
            String _nextCursor = (String)_nextCursorToken.get(0);
            IamListPoliciesRequestBuilder _ret = this.listPolicies();
            _ret.request(new IamListPoliciesRequest(request.xAccountId(), request.raw(), request.proxy(), request.fields(), request.filter(), request.page(), request.pageSize(), request.next(), request.updatedAfter(), request.expand()));
            return Optional.of(_ret.call());
        });
        IamListPoliciesResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                IamPoliciesPaginated _out = (IamPoliciesPaginated)Utils.mapper().readValue(new String(_fullResponse, StandardCharsets.UTF_8), (TypeReference)new TypeReference<IamPoliciesPaginated>(){});
                _res.withIamPoliciesPaginated(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), _fullResponse);
    }

    public IamGetPolicyRequestBuilder getPolicy() {
        return new IamGetPolicyRequestBuilder(this);
    }

    public IamGetPolicyResponse getPolicy(IamGetPolicyRequest request) throws Exception {
        return this.getPolicy(request, Optional.empty());
    }

    @Override
    public IamGetPolicyResponse getPolicy(IamGetPolicyRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(IamGetPolicyRequest.class, _baseUrl, "/unified/iam/policies/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(IamGetPolicyRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("iam_get_policy", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("iam_get_policy", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("iam_get_policy", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        IamGetPolicyResponse.Builder _resBuilder = IamGetPolicyResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        IamGetPolicyResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                IamPolicyResult _out = (IamPolicyResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<IamPolicyResult>(){});
                _res.withIamPolicyResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

