/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class InAppMessagesValue {
    public static final InAppMessagesValue EMAIL = new InAppMessagesValue("email");
    public static final InAppMessagesValue SMS = new InAppMessagesValue("sms");
    public static final InAppMessagesValue PUSH = new InAppMessagesValue("push");
    public static final InAppMessagesValue WEB_PUSH = new InAppMessagesValue("web_push");
    public static final InAppMessagesValue IOS_PUSH = new InAppMessagesValue("ios_push");
    public static final InAppMessagesValue ANDROID_PUSH = new InAppMessagesValue("android_push");
    public static final InAppMessagesValue APP_PUSH = new InAppMessagesValue("app_push");
    public static final InAppMessagesValue OMNI_CHANNEL = new InAppMessagesValue("omni_channel");
    public static final InAppMessagesValue CONTENT_BLOCK = new InAppMessagesValue("content_block");
    public static final InAppMessagesValue IN_APP = new InAppMessagesValue("in_app");
    public static final InAppMessagesValue UNKNOWN = new InAppMessagesValue("unknown");
    public static final InAppMessagesValue UNMAPPED_VALUE = new InAppMessagesValue("unmapped_value");
    private static final Map<String, InAppMessagesValue> values = InAppMessagesValue.createValuesMap();
    private static final Map<String, InAppMessagesValueEnum> enums = InAppMessagesValue.createEnumsMap();
    private final String value;

    private InAppMessagesValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InAppMessagesValue of(String value) {
        Class<InAppMessagesValue> clazz = InAppMessagesValue.class;
        synchronized (InAppMessagesValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new InAppMessagesValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<InAppMessagesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InAppMessagesValue other = (InAppMessagesValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "InAppMessagesValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InAppMessagesValue[] values() {
        Class<InAppMessagesValue> clazz = InAppMessagesValue.class;
        synchronized (InAppMessagesValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new InAppMessagesValue[0]);
        }
    }

    private static final Map<String, InAppMessagesValue> createValuesMap() {
        LinkedHashMap<String, InAppMessagesValue> map = new LinkedHashMap<String, InAppMessagesValue>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, InAppMessagesValueEnum> createEnumsMap() {
        HashMap<String, InAppMessagesValueEnum> map = new HashMap<String, InAppMessagesValueEnum>();
        map.put("email", InAppMessagesValueEnum.EMAIL);
        map.put("sms", InAppMessagesValueEnum.SMS);
        map.put("push", InAppMessagesValueEnum.PUSH);
        map.put("web_push", InAppMessagesValueEnum.WEB_PUSH);
        map.put("ios_push", InAppMessagesValueEnum.IOS_PUSH);
        map.put("android_push", InAppMessagesValueEnum.ANDROID_PUSH);
        map.put("app_push", InAppMessagesValueEnum.APP_PUSH);
        map.put("omni_channel", InAppMessagesValueEnum.OMNI_CHANNEL);
        map.put("content_block", InAppMessagesValueEnum.CONTENT_BLOCK);
        map.put("in_app", InAppMessagesValueEnum.IN_APP);
        map.put("unknown", InAppMessagesValueEnum.UNKNOWN);
        map.put("unmapped_value", InAppMessagesValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum InAppMessagesValueEnum {
        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private InAppMessagesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<InAppMessagesValue> {
        protected _Deserializer() {
            super(InAppMessagesValue.class);
        }

        public InAppMessagesValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return InAppMessagesValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<InAppMessagesValue> {
        protected _Serializer() {
            super(InAppMessagesValue.class);
        }

        public void serialize(InAppMessagesValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

