/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScheduledInterviewsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class AtsListApplicationsScheduledInterviewsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<AtsListApplicationsScheduledInterviewsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public AtsListApplicationsScheduledInterviewsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.scheduledInterviewsPaginated = scheduledInterviewsPaginated;
        this.headers = headers;
    }

    public AtsListApplicationsScheduledInterviewsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ScheduledInterviewsPaginated> scheduledInterviewsPaginated() {
        return this.scheduledInterviewsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<AtsListApplicationsScheduledInterviewsResponse> next() throws Exception {
        return this.next.call();
    }

    private AtsListApplicationsScheduledInterviewsResponse withNext(Callable<Optional<AtsListApplicationsScheduledInterviewsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListApplicationsScheduledInterviewsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withScheduledInterviewsPaginated(ScheduledInterviewsPaginated scheduledInterviewsPaginated) {
        Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
        this.scheduledInterviewsPaginated = Optional.ofNullable(scheduledInterviewsPaginated);
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withScheduledInterviewsPaginated(Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated) {
        Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
        this.scheduledInterviewsPaginated = scheduledInterviewsPaginated;
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListApplicationsScheduledInterviewsResponse other = (AtsListApplicationsScheduledInterviewsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.scheduledInterviewsPaginated, other.scheduledInterviewsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.scheduledInterviewsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListApplicationsScheduledInterviewsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "scheduledInterviewsPaginated", this.scheduledInterviewsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<AtsListApplicationsScheduledInterviewsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder scheduledInterviewsPaginated(ScheduledInterviewsPaginated scheduledInterviewsPaginated) {
            Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
            this.scheduledInterviewsPaginated = Optional.ofNullable(scheduledInterviewsPaginated);
            return this;
        }

        public Builder scheduledInterviewsPaginated(Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated) {
            Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
            this.scheduledInterviewsPaginated = scheduledInterviewsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<AtsListApplicationsScheduledInterviewsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public AtsListApplicationsScheduledInterviewsResponse build() {
            return new AtsListApplicationsScheduledInterviewsResponse(this.contentType, this.statusCode, this.rawResponse, this.scheduledInterviewsPaginated, this.headers).withNext(this.next);
        }
    }
}

