/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class Course {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The external ID associated with this course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("external_reference")
    private JsonNullable<String> externalReference;

    /**
     * The child ID/IDs associated with this course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_ids")
    private JsonNullable<? extends List<String>> contentIds;

    /**
     * Provider's unique identifier of the child content IDs associated with this course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_content_ids")
    private JsonNullable<? extends List<String>> remoteContentIds;

    /**
     * The title of the course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private JsonNullable<String> title;

    /**
     * The description of the course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The languages associated with this course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("languages")
    private JsonNullable<? extends List<LanguageEnum>> languages;

    /**
     * The URL of the thumbnail image associated with the course.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cover_url")
    private JsonNullable<String> coverUrl;

    /**
     * The redirect URL of the course.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<String> url;

    /**
     * Whether the course is active and available for users.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<? extends CourseActive> active;

    /**
     * The duration of the course following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("duration")
    private JsonNullable<String> duration;

    /**
     * The categories associated with this course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("categories")
    private JsonNullable<? extends List<Category>> categories;

    /**
     * The skills associated with this course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("skills")
    private JsonNullable<? extends List<Skills>> skills;

    /**
     * The name of the course provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider")
    private JsonNullable<String> provider;

    /**
     * The authors of the course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("authors")
    private JsonNullable<? extends List<AuthorModel>> authors;

    /**
     * The date on which the course was last updated.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * The date on which the course was created.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    @JsonCreator
    public Course(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("external_reference") JsonNullable<String> externalReference,
            @JsonProperty("content_ids") JsonNullable<? extends List<String>> contentIds,
            @JsonProperty("remote_content_ids") JsonNullable<? extends List<String>> remoteContentIds,
            @JsonProperty("title") JsonNullable<String> title,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("languages") JsonNullable<? extends List<LanguageEnum>> languages,
            @JsonProperty("cover_url") JsonNullable<String> coverUrl,
            @JsonProperty("url") JsonNullable<String> url,
            @JsonProperty("active") JsonNullable<? extends CourseActive> active,
            @JsonProperty("duration") JsonNullable<String> duration,
            @JsonProperty("categories") JsonNullable<? extends List<Category>> categories,
            @JsonProperty("skills") JsonNullable<? extends List<Skills>> skills,
            @JsonProperty("provider") JsonNullable<String> provider,
            @JsonProperty("authors") JsonNullable<? extends List<AuthorModel>> authors,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(externalReference, "externalReference");
        Utils.checkNotNull(contentIds, "contentIds");
        Utils.checkNotNull(remoteContentIds, "remoteContentIds");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(languages, "languages");
        Utils.checkNotNull(coverUrl, "coverUrl");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(duration, "duration");
        Utils.checkNotNull(categories, "categories");
        Utils.checkNotNull(skills, "skills");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(authors, "authors");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.externalReference = externalReference;
        this.contentIds = contentIds;
        this.remoteContentIds = remoteContentIds;
        this.title = title;
        this.description = description;
        this.languages = languages;
        this.coverUrl = coverUrl;
        this.url = url;
        this.active = active;
        this.duration = duration;
        this.categories = categories;
        this.skills = skills;
        this.provider = provider;
        this.authors = authors;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
    }
    
    public Course() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The external ID associated with this course
     */
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    /**
     * The child ID/IDs associated with this course
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> contentIds() {
        return (JsonNullable<List<String>>) contentIds;
    }

    /**
     * Provider's unique identifier of the child content IDs associated with this course
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteContentIds() {
        return (JsonNullable<List<String>>) remoteContentIds;
    }

    /**
     * The title of the course
     */
    @JsonIgnore
    public JsonNullable<String> title() {
        return title;
    }

    /**
     * The description of the course
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The languages associated with this course
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<LanguageEnum>> languages() {
        return (JsonNullable<List<LanguageEnum>>) languages;
    }

    /**
     * The URL of the thumbnail image associated with the course.
     */
    @JsonIgnore
    public JsonNullable<String> coverUrl() {
        return coverUrl;
    }

    /**
     * The redirect URL of the course.
     */
    @JsonIgnore
    public JsonNullable<String> url() {
        return url;
    }

    /**
     * Whether the course is active and available for users.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CourseActive> active() {
        return (JsonNullable<CourseActive>) active;
    }

    /**
     * The duration of the course following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string
     */
    @JsonIgnore
    public JsonNullable<String> duration() {
        return duration;
    }

    /**
     * The categories associated with this course
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Category>> categories() {
        return (JsonNullable<List<Category>>) categories;
    }

    /**
     * The skills associated with this course
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Skills>> skills() {
        return (JsonNullable<List<Skills>>) skills;
    }

    /**
     * The name of the course provider
     */
    @JsonIgnore
    public JsonNullable<String> provider() {
        return provider;
    }

    /**
     * The authors of the course
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<AuthorModel>> authors() {
        return (JsonNullable<List<AuthorModel>>) authors;
    }

    /**
     * The date on which the course was last updated.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * The date on which the course was created.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public Course withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Course withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Course withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Course withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Course withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Course withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The external ID associated with this course
     */
    public Course withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * The external ID associated with this course
     */
    public Course withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }

    /**
     * The child ID/IDs associated with this course
     */
    public Course withContentIds(List<String> contentIds) {
        Utils.checkNotNull(contentIds, "contentIds");
        this.contentIds = JsonNullable.of(contentIds);
        return this;
    }

    /**
     * The child ID/IDs associated with this course
     */
    public Course withContentIds(JsonNullable<? extends List<String>> contentIds) {
        Utils.checkNotNull(contentIds, "contentIds");
        this.contentIds = contentIds;
        return this;
    }

    /**
     * Provider's unique identifier of the child content IDs associated with this course
     */
    public Course withRemoteContentIds(List<String> remoteContentIds) {
        Utils.checkNotNull(remoteContentIds, "remoteContentIds");
        this.remoteContentIds = JsonNullable.of(remoteContentIds);
        return this;
    }

    /**
     * Provider's unique identifier of the child content IDs associated with this course
     */
    public Course withRemoteContentIds(JsonNullable<? extends List<String>> remoteContentIds) {
        Utils.checkNotNull(remoteContentIds, "remoteContentIds");
        this.remoteContentIds = remoteContentIds;
        return this;
    }

    /**
     * The title of the course
     */
    public Course withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of(title);
        return this;
    }

    /**
     * The title of the course
     */
    public Course withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * The description of the course
     */
    public Course withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The description of the course
     */
    public Course withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The languages associated with this course
     */
    public Course withLanguages(List<LanguageEnum> languages) {
        Utils.checkNotNull(languages, "languages");
        this.languages = JsonNullable.of(languages);
        return this;
    }

    /**
     * The languages associated with this course
     */
    public Course withLanguages(JsonNullable<? extends List<LanguageEnum>> languages) {
        Utils.checkNotNull(languages, "languages");
        this.languages = languages;
        return this;
    }

    /**
     * The URL of the thumbnail image associated with the course.
     */
    public Course withCoverUrl(String coverUrl) {
        Utils.checkNotNull(coverUrl, "coverUrl");
        this.coverUrl = JsonNullable.of(coverUrl);
        return this;
    }

    /**
     * The URL of the thumbnail image associated with the course.
     */
    public Course withCoverUrl(JsonNullable<String> coverUrl) {
        Utils.checkNotNull(coverUrl, "coverUrl");
        this.coverUrl = coverUrl;
        return this;
    }

    /**
     * The redirect URL of the course.
     */
    public Course withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * The redirect URL of the course.
     */
    public Course withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    /**
     * Whether the course is active and available for users.
     */
    public Course withActive(CourseActive active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Whether the course is active and available for users.
     */
    public Course withActive(JsonNullable<? extends CourseActive> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    /**
     * The duration of the course following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string
     */
    public Course withDuration(String duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = JsonNullable.of(duration);
        return this;
    }

    /**
     * The duration of the course following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string
     */
    public Course withDuration(JsonNullable<String> duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = duration;
        return this;
    }

    /**
     * The categories associated with this course
     */
    public Course withCategories(List<Category> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = JsonNullable.of(categories);
        return this;
    }

    /**
     * The categories associated with this course
     */
    public Course withCategories(JsonNullable<? extends List<Category>> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = categories;
        return this;
    }

    /**
     * The skills associated with this course
     */
    public Course withSkills(List<Skills> skills) {
        Utils.checkNotNull(skills, "skills");
        this.skills = JsonNullable.of(skills);
        return this;
    }

    /**
     * The skills associated with this course
     */
    public Course withSkills(JsonNullable<? extends List<Skills>> skills) {
        Utils.checkNotNull(skills, "skills");
        this.skills = skills;
        return this;
    }

    /**
     * The name of the course provider
     */
    public Course withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = JsonNullable.of(provider);
        return this;
    }

    /**
     * The name of the course provider
     */
    public Course withProvider(JsonNullable<String> provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    /**
     * The authors of the course
     */
    public Course withAuthors(List<AuthorModel> authors) {
        Utils.checkNotNull(authors, "authors");
        this.authors = JsonNullable.of(authors);
        return this;
    }

    /**
     * The authors of the course
     */
    public Course withAuthors(JsonNullable<? extends List<AuthorModel>> authors) {
        Utils.checkNotNull(authors, "authors");
        this.authors = authors;
        return this;
    }

    /**
     * The date on which the course was last updated.
     */
    public Course withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The date on which the course was last updated.
     */
    public Course withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * The date on which the course was created.
     */
    public Course withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The date on which the course was created.
     */
    public Course withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Course other = (Course) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.externalReference, other.externalReference) &&
            Utils.enhancedDeepEquals(this.contentIds, other.contentIds) &&
            Utils.enhancedDeepEquals(this.remoteContentIds, other.remoteContentIds) &&
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.languages, other.languages) &&
            Utils.enhancedDeepEquals(this.coverUrl, other.coverUrl) &&
            Utils.enhancedDeepEquals(this.url, other.url) &&
            Utils.enhancedDeepEquals(this.active, other.active) &&
            Utils.enhancedDeepEquals(this.duration, other.duration) &&
            Utils.enhancedDeepEquals(this.categories, other.categories) &&
            Utils.enhancedDeepEquals(this.skills, other.skills) &&
            Utils.enhancedDeepEquals(this.provider, other.provider) &&
            Utils.enhancedDeepEquals(this.authors, other.authors) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, unifiedCustomFields,
            externalReference, contentIds, remoteContentIds,
            title, description, languages,
            coverUrl, url, active,
            duration, categories, skills,
            provider, authors, updatedAt,
            createdAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Course.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "externalReference", externalReference,
                "contentIds", contentIds,
                "remoteContentIds", remoteContentIds,
                "title", title,
                "description", description,
                "languages", languages,
                "coverUrl", coverUrl,
                "url", url,
                "active", active,
                "duration", duration,
                "categories", categories,
                "skills", skills,
                "provider", provider,
                "authors", authors,
                "updatedAt", updatedAt,
                "createdAt", createdAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();

        private JsonNullable<String> externalReference = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> contentIds = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> remoteContentIds = JsonNullable.undefined();

        private JsonNullable<String> title = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<? extends List<LanguageEnum>> languages = JsonNullable.undefined();

        private JsonNullable<String> coverUrl = JsonNullable.undefined();

        private JsonNullable<String> url = JsonNullable.undefined();

        private JsonNullable<? extends CourseActive> active = JsonNullable.undefined();

        private JsonNullable<String> duration = JsonNullable.undefined();

        private JsonNullable<? extends List<Category>> categories = JsonNullable.undefined();

        private JsonNullable<? extends List<Skills>> skills = JsonNullable.undefined();

        private JsonNullable<String> provider = JsonNullable.undefined();

        private JsonNullable<? extends List<AuthorModel>> authors = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }


        /**
         * The external ID associated with this course
         */
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * The external ID associated with this course
         */
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }


        /**
         * The child ID/IDs associated with this course
         */
        public Builder contentIds(List<String> contentIds) {
            Utils.checkNotNull(contentIds, "contentIds");
            this.contentIds = JsonNullable.of(contentIds);
            return this;
        }

        /**
         * The child ID/IDs associated with this course
         */
        public Builder contentIds(JsonNullable<? extends List<String>> contentIds) {
            Utils.checkNotNull(contentIds, "contentIds");
            this.contentIds = contentIds;
            return this;
        }


        /**
         * Provider's unique identifier of the child content IDs associated with this course
         */
        public Builder remoteContentIds(List<String> remoteContentIds) {
            Utils.checkNotNull(remoteContentIds, "remoteContentIds");
            this.remoteContentIds = JsonNullable.of(remoteContentIds);
            return this;
        }

        /**
         * Provider's unique identifier of the child content IDs associated with this course
         */
        public Builder remoteContentIds(JsonNullable<? extends List<String>> remoteContentIds) {
            Utils.checkNotNull(remoteContentIds, "remoteContentIds");
            this.remoteContentIds = remoteContentIds;
            return this;
        }


        /**
         * The title of the course
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of(title);
            return this;
        }

        /**
         * The title of the course
         */
        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        /**
         * The description of the course
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The description of the course
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * The languages associated with this course
         */
        public Builder languages(List<LanguageEnum> languages) {
            Utils.checkNotNull(languages, "languages");
            this.languages = JsonNullable.of(languages);
            return this;
        }

        /**
         * The languages associated with this course
         */
        public Builder languages(JsonNullable<? extends List<LanguageEnum>> languages) {
            Utils.checkNotNull(languages, "languages");
            this.languages = languages;
            return this;
        }


        /**
         * The URL of the thumbnail image associated with the course.
         */
        public Builder coverUrl(String coverUrl) {
            Utils.checkNotNull(coverUrl, "coverUrl");
            this.coverUrl = JsonNullable.of(coverUrl);
            return this;
        }

        /**
         * The URL of the thumbnail image associated with the course.
         */
        public Builder coverUrl(JsonNullable<String> coverUrl) {
            Utils.checkNotNull(coverUrl, "coverUrl");
            this.coverUrl = coverUrl;
            return this;
        }


        /**
         * The redirect URL of the course.
         */
        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * The redirect URL of the course.
         */
        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }


        /**
         * Whether the course is active and available for users.
         */
        public Builder active(CourseActive active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Whether the course is active and available for users.
         */
        public Builder active(JsonNullable<? extends CourseActive> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }


        /**
         * The duration of the course following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string
         */
        public Builder duration(String duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = JsonNullable.of(duration);
            return this;
        }

        /**
         * The duration of the course following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string
         */
        public Builder duration(JsonNullable<String> duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = duration;
            return this;
        }


        /**
         * The categories associated with this course
         */
        public Builder categories(List<Category> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = JsonNullable.of(categories);
            return this;
        }

        /**
         * The categories associated with this course
         */
        public Builder categories(JsonNullable<? extends List<Category>> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = categories;
            return this;
        }


        /**
         * The skills associated with this course
         */
        public Builder skills(List<Skills> skills) {
            Utils.checkNotNull(skills, "skills");
            this.skills = JsonNullable.of(skills);
            return this;
        }

        /**
         * The skills associated with this course
         */
        public Builder skills(JsonNullable<? extends List<Skills>> skills) {
            Utils.checkNotNull(skills, "skills");
            this.skills = skills;
            return this;
        }


        /**
         * The name of the course provider
         */
        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = JsonNullable.of(provider);
            return this;
        }

        /**
         * The name of the course provider
         */
        public Builder provider(JsonNullable<String> provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }


        /**
         * The authors of the course
         */
        public Builder authors(List<AuthorModel> authors) {
            Utils.checkNotNull(authors, "authors");
            this.authors = JsonNullable.of(authors);
            return this;
        }

        /**
         * The authors of the course
         */
        public Builder authors(JsonNullable<? extends List<AuthorModel>> authors) {
            Utils.checkNotNull(authors, "authors");
            this.authors = authors;
            return this;
        }


        /**
         * The date on which the course was last updated.
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The date on which the course was last updated.
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * The date on which the course was created.
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The date on which the course was created.
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Course build() {

            return new Course(
                id, remoteId, unifiedCustomFields,
                externalReference, contentIds, remoteContentIds,
                title, description, languages,
                coverUrl, url, active,
                duration, categories, skills,
                provider, authors, updatedAt,
                createdAt);
        }

    }
}
