/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.MessagingCreateConversationRequestDto;
import com.stackone.stackone_client_java.models.components.MessagingMessageSendRequestDto;
import com.stackone.stackone_client_java.models.operations.MessagingCreateConversationRequest;
import com.stackone.stackone_client_java.models.operations.MessagingDownloadMessagingAttachmentRequest;
import com.stackone.stackone_client_java.models.operations.MessagingGetAttachmentRequest;
import com.stackone.stackone_client_java.models.operations.MessagingGetConversationRequest;
import com.stackone.stackone_client_java.models.operations.MessagingGetMessageRequest;
import com.stackone.stackone_client_java.models.operations.MessagingGetUserRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListAttachmentsRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationMessagesRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationsRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListUsersRequest;
import com.stackone.stackone_client_java.models.operations.MessagingSendMessageRequest;
import com.stackone.stackone_client_java.models.operations.async.MessagingCreateConversationRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingCreateConversationResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingDownloadMessagingAttachmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingDownloadMessagingAttachmentResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetAttachmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetAttachmentResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetConversationRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetConversationResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetMessageRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetMessageResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetUserResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingListAttachmentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingListAttachmentsResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingListConversationMessagesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingListConversationMessagesResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingListConversationsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingListConversationsResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingListUsersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingListUsersResponse;
import com.stackone.stackone_client_java.models.operations.async.MessagingSendMessageRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.MessagingSendMessageResponse;
import com.stackone.stackone_client_java.operations.MessagingCreateConversation;
import com.stackone.stackone_client_java.operations.MessagingDownloadMessagingAttachment;
import com.stackone.stackone_client_java.operations.MessagingGetAttachment;
import com.stackone.stackone_client_java.operations.MessagingGetConversation;
import com.stackone.stackone_client_java.operations.MessagingGetMessage;
import com.stackone.stackone_client_java.operations.MessagingGetUser;
import com.stackone.stackone_client_java.operations.MessagingListAttachments;
import com.stackone.stackone_client_java.operations.MessagingListConversationMessages;
import com.stackone.stackone_client_java.operations.MessagingListConversations;
import com.stackone.stackone_client_java.operations.MessagingListUsers;
import com.stackone.stackone_client_java.operations.MessagingSendMessage;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


public class AsyncMessaging {
    private final SDKConfiguration sdkConfiguration;
    private final Messaging syncSDK;

    AsyncMessaging(Messaging syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Messaging sync() {
        return syncSDK;
    }


    /**
     * List Conversations
     * 
     * @return The async call builder
     */
    public MessagingListConversationsRequestBuilder listConversations() {
        return new MessagingListConversationsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Conversations
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingListConversationsResponse&gt; - The async response
     */
    public CompletableFuture<MessagingListConversationsResponse> listConversations(MessagingListConversationsRequest request) {
        return listConversations(request, Optional.empty());
    }

    /**
     * List Conversations
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingListConversationsResponse&gt; - The async response
     */
    public CompletableFuture<MessagingListConversationsResponse> listConversations(MessagingListConversationsRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingListConversationsRequest, MessagingListConversationsResponse> operation
              = new MessagingListConversations.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Create Conversation
     * 
     * @return The async call builder
     */
    public MessagingCreateConversationRequestBuilder createConversation() {
        return new MessagingCreateConversationRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Conversation
     * 
     * @param xAccountId The account identifier
     * @param messagingCreateConversationRequestDto 
     * @return CompletableFuture&lt;MessagingCreateConversationResponse&gt; - The async response
     */
    public CompletableFuture<MessagingCreateConversationResponse> createConversation(String xAccountId, MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
        return createConversation(xAccountId, messagingCreateConversationRequestDto, Optional.empty());
    }

    /**
     * Create Conversation
     * 
     * @param xAccountId The account identifier
     * @param messagingCreateConversationRequestDto 
     * @param options additional options
     * @return CompletableFuture&lt;MessagingCreateConversationResponse&gt; - The async response
     */
    public CompletableFuture<MessagingCreateConversationResponse> createConversation(
            String xAccountId, MessagingCreateConversationRequestDto messagingCreateConversationRequestDto,
            Optional<Options> options) {
        MessagingCreateConversationRequest request =
            MessagingCreateConversationRequest
                .builder()
                .xAccountId(xAccountId)
                .messagingCreateConversationRequestDto(messagingCreateConversationRequestDto)
                .build();
        AsyncRequestOperation<MessagingCreateConversationRequest, MessagingCreateConversationResponse> operation
              = new MessagingCreateConversation.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Conversation
     * 
     * @return The async call builder
     */
    public MessagingGetConversationRequestBuilder getConversation() {
        return new MessagingGetConversationRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Conversation
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingGetConversationResponse&gt; - The async response
     */
    public CompletableFuture<MessagingGetConversationResponse> getConversation(MessagingGetConversationRequest request) {
        return getConversation(request, Optional.empty());
    }

    /**
     * Get Conversation
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingGetConversationResponse&gt; - The async response
     */
    public CompletableFuture<MessagingGetConversationResponse> getConversation(MessagingGetConversationRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingGetConversationRequest, MessagingGetConversationResponse> operation
              = new MessagingGetConversation.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Download Attachment
     * 
     * @return The async call builder
     */
    public MessagingDownloadMessagingAttachmentRequestBuilder downloadMessagingAttachment() {
        return new MessagingDownloadMessagingAttachmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Download Attachment
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingDownloadMessagingAttachmentResponse&gt; - The async response
     */
    public CompletableFuture<MessagingDownloadMessagingAttachmentResponse> downloadMessagingAttachment(MessagingDownloadMessagingAttachmentRequest request) {
        return downloadMessagingAttachment(request, Optional.empty());
    }

    /**
     * Download Attachment
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingDownloadMessagingAttachmentResponse&gt; - The async response
     */
    public CompletableFuture<MessagingDownloadMessagingAttachmentResponse> downloadMessagingAttachment(MessagingDownloadMessagingAttachmentRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingDownloadMessagingAttachmentRequest, MessagingDownloadMessagingAttachmentResponse> operation
              = new MessagingDownloadMessagingAttachment.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Attachments
     * 
     * @return The async call builder
     */
    public MessagingListAttachmentsRequestBuilder listAttachments() {
        return new MessagingListAttachmentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Attachments
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingListAttachmentsResponse&gt; - The async response
     */
    public CompletableFuture<MessagingListAttachmentsResponse> listAttachments(MessagingListAttachmentsRequest request) {
        return listAttachments(request, Optional.empty());
    }

    /**
     * List Attachments
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingListAttachmentsResponse&gt; - The async response
     */
    public CompletableFuture<MessagingListAttachmentsResponse> listAttachments(MessagingListAttachmentsRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingListAttachmentsRequest, MessagingListAttachmentsResponse> operation
              = new MessagingListAttachments.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Attachment
     * 
     * @return The async call builder
     */
    public MessagingGetAttachmentRequestBuilder getAttachment() {
        return new MessagingGetAttachmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Attachment
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingGetAttachmentResponse&gt; - The async response
     */
    public CompletableFuture<MessagingGetAttachmentResponse> getAttachment(MessagingGetAttachmentRequest request) {
        return getAttachment(request, Optional.empty());
    }

    /**
     * Get Attachment
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingGetAttachmentResponse&gt; - The async response
     */
    public CompletableFuture<MessagingGetAttachmentResponse> getAttachment(MessagingGetAttachmentRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingGetAttachmentRequest, MessagingGetAttachmentResponse> operation
              = new MessagingGetAttachment.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Users
     * 
     * @return The async call builder
     */
    public MessagingListUsersRequestBuilder listUsers() {
        return new MessagingListUsersRequestBuilder(sdkConfiguration);
    }

    /**
     * List Users
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingListUsersResponse&gt; - The async response
     */
    public CompletableFuture<MessagingListUsersResponse> listUsers(MessagingListUsersRequest request) {
        return listUsers(request, Optional.empty());
    }

    /**
     * List Users
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingListUsersResponse&gt; - The async response
     */
    public CompletableFuture<MessagingListUsersResponse> listUsers(MessagingListUsersRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingListUsersRequest, MessagingListUsersResponse> operation
              = new MessagingListUsers.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get User
     * 
     * @return The async call builder
     */
    public MessagingGetUserRequestBuilder getUser() {
        return new MessagingGetUserRequestBuilder(sdkConfiguration);
    }

    /**
     * Get User
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingGetUserResponse&gt; - The async response
     */
    public CompletableFuture<MessagingGetUserResponse> getUser(MessagingGetUserRequest request) {
        return getUser(request, Optional.empty());
    }

    /**
     * Get User
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingGetUserResponse&gt; - The async response
     */
    public CompletableFuture<MessagingGetUserResponse> getUser(MessagingGetUserRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingGetUserRequest, MessagingGetUserResponse> operation
              = new MessagingGetUser.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Conversation Messages
     * 
     * @return The async call builder
     */
    public MessagingListConversationMessagesRequestBuilder listConversationMessages() {
        return new MessagingListConversationMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Conversation Messages
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingListConversationMessagesResponse&gt; - The async response
     */
    public CompletableFuture<MessagingListConversationMessagesResponse> listConversationMessages(MessagingListConversationMessagesRequest request) {
        return listConversationMessages(request, Optional.empty());
    }

    /**
     * List Conversation Messages
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingListConversationMessagesResponse&gt; - The async response
     */
    public CompletableFuture<MessagingListConversationMessagesResponse> listConversationMessages(MessagingListConversationMessagesRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingListConversationMessagesRequest, MessagingListConversationMessagesResponse> operation
              = new MessagingListConversationMessages.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Message
     * 
     * @return The async call builder
     */
    public MessagingGetMessageRequestBuilder getMessage() {
        return new MessagingGetMessageRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Message
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;MessagingGetMessageResponse&gt; - The async response
     */
    public CompletableFuture<MessagingGetMessageResponse> getMessage(MessagingGetMessageRequest request) {
        return getMessage(request, Optional.empty());
    }

    /**
     * Get Message
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;MessagingGetMessageResponse&gt; - The async response
     */
    public CompletableFuture<MessagingGetMessageResponse> getMessage(MessagingGetMessageRequest request, Optional<Options> options) {
        AsyncRequestOperation<MessagingGetMessageRequest, MessagingGetMessageResponse> operation
              = new MessagingGetMessage.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Send Message
     * 
     * @return The async call builder
     */
    public MessagingSendMessageRequestBuilder sendMessage() {
        return new MessagingSendMessageRequestBuilder(sdkConfiguration);
    }

    /**
     * Send Message
     * 
     * @param xAccountId The account identifier
     * @param messagingMessageSendRequestDto 
     * @return CompletableFuture&lt;MessagingSendMessageResponse&gt; - The async response
     */
    public CompletableFuture<MessagingSendMessageResponse> sendMessage(String xAccountId, MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        return sendMessage(xAccountId, messagingMessageSendRequestDto, Optional.empty());
    }

    /**
     * Send Message
     * 
     * @param xAccountId The account identifier
     * @param messagingMessageSendRequestDto 
     * @param options additional options
     * @return CompletableFuture&lt;MessagingSendMessageResponse&gt; - The async response
     */
    public CompletableFuture<MessagingSendMessageResponse> sendMessage(
            String xAccountId, MessagingMessageSendRequestDto messagingMessageSendRequestDto,
            Optional<Options> options) {
        MessagingSendMessageRequest request =
            MessagingSendMessageRequest
                .builder()
                .xAccountId(xAccountId)
                .messagingMessageSendRequestDto(messagingMessageSendRequestDto)
                .build();
        AsyncRequestOperation<MessagingSendMessageRequest, MessagingSendMessageResponse> operation
              = new MessagingSendMessage.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
