/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class AccountingAccountResultData {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * ID of the company this account belongs to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("company_id")
    private JsonNullable<String> companyId;

    /**
     * External system's account code/number
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("code")
    private JsonNullable<String> code;

    /**
     * Name of the account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * Type of account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends AccountingAccountResultType> type;

    /**
     * Whether the account is active
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<? extends AccountingAccountResultActive> active;

    @JsonCreator
    public AccountingAccountResultData(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("company_id") JsonNullable<String> companyId,
            @JsonProperty("code") JsonNullable<String> code,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("type") JsonNullable<? extends AccountingAccountResultType> type,
            @JsonProperty("active") JsonNullable<? extends AccountingAccountResultActive> active) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(companyId, "companyId");
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(active, "active");
        this.id = id;
        this.remoteId = remoteId;
        this.companyId = companyId;
        this.code = code;
        this.name = name;
        this.type = type;
        this.active = active;
    }
    
    public AccountingAccountResultData() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * ID of the company this account belongs to
     */
    @JsonIgnore
    public JsonNullable<String> companyId() {
        return companyId;
    }

    /**
     * External system's account code/number
     */
    @JsonIgnore
    public JsonNullable<String> code() {
        return code;
    }

    /**
     * Name of the account
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Type of account
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingAccountResultType> type() {
        return (JsonNullable<AccountingAccountResultType>) type;
    }

    /**
     * Whether the account is active
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingAccountResultActive> active() {
        return (JsonNullable<AccountingAccountResultActive>) active;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public AccountingAccountResultData withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public AccountingAccountResultData withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AccountingAccountResultData withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AccountingAccountResultData withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * ID of the company this account belongs to
     */
    public AccountingAccountResultData withCompanyId(String companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = JsonNullable.of(companyId);
        return this;
    }

    /**
     * ID of the company this account belongs to
     */
    public AccountingAccountResultData withCompanyId(JsonNullable<String> companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = companyId;
        return this;
    }

    /**
     * External system's account code/number
     */
    public AccountingAccountResultData withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = JsonNullable.of(code);
        return this;
    }

    /**
     * External system's account code/number
     */
    public AccountingAccountResultData withCode(JsonNullable<String> code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    /**
     * Name of the account
     */
    public AccountingAccountResultData withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * Name of the account
     */
    public AccountingAccountResultData withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Type of account
     */
    public AccountingAccountResultData withType(AccountingAccountResultType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * Type of account
     */
    public AccountingAccountResultData withType(JsonNullable<? extends AccountingAccountResultType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * Whether the account is active
     */
    public AccountingAccountResultData withActive(AccountingAccountResultActive active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Whether the account is active
     */
    public AccountingAccountResultData withActive(JsonNullable<? extends AccountingAccountResultActive> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingAccountResultData other = (AccountingAccountResultData) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.companyId, other.companyId) &&
            Utils.enhancedDeepEquals(this.code, other.code) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.active, other.active);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, companyId,
            code, name, type,
            active);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingAccountResultData.class,
                "id", id,
                "remoteId", remoteId,
                "companyId", companyId,
                "code", code,
                "name", name,
                "type", type,
                "active", active);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> companyId = JsonNullable.undefined();

        private JsonNullable<String> code = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<? extends AccountingAccountResultType> type = JsonNullable.undefined();

        private JsonNullable<? extends AccountingAccountResultActive> active = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * ID of the company this account belongs to
         */
        public Builder companyId(String companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = JsonNullable.of(companyId);
            return this;
        }

        /**
         * ID of the company this account belongs to
         */
        public Builder companyId(JsonNullable<String> companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = companyId;
            return this;
        }


        /**
         * External system's account code/number
         */
        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = JsonNullable.of(code);
            return this;
        }

        /**
         * External system's account code/number
         */
        public Builder code(JsonNullable<String> code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }


        /**
         * Name of the account
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * Name of the account
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * Type of account
         */
        public Builder type(AccountingAccountResultType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * Type of account
         */
        public Builder type(JsonNullable<? extends AccountingAccountResultType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * Whether the account is active
         */
        public Builder active(AccountingAccountResultActive active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Whether the account is active
         */
        public Builder active(JsonNullable<? extends AccountingAccountResultActive> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public AccountingAccountResultData build() {

            return new AccountingAccountResultData(
                id, remoteId, companyId,
                code, name, type,
                active);
        }

    }
}
