/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * CreateEmploymentApiModelWorkTimeValue
 * 
 * <p>The unified value for the period.
 */
@JsonDeserialize(using = CreateEmploymentApiModelWorkTimeValue._Deserializer.class)
@JsonSerialize(using = CreateEmploymentApiModelWorkTimeValue._Serializer.class)
public class CreateEmploymentApiModelWorkTimeValue {

    public static final CreateEmploymentApiModelWorkTimeValue DAY = new CreateEmploymentApiModelWorkTimeValue("day");
    public static final CreateEmploymentApiModelWorkTimeValue WEEK = new CreateEmploymentApiModelWorkTimeValue("week");
    public static final CreateEmploymentApiModelWorkTimeValue MONTH = new CreateEmploymentApiModelWorkTimeValue("month");
    public static final CreateEmploymentApiModelWorkTimeValue YEAR = new CreateEmploymentApiModelWorkTimeValue("year");
    public static final CreateEmploymentApiModelWorkTimeValue UNMAPPED_VALUE = new CreateEmploymentApiModelWorkTimeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CreateEmploymentApiModelWorkTimeValue> values = createValuesMap();
    private static final Map<String, CreateEmploymentApiModelWorkTimeValueEnum> enums = createEnumsMap();

    private final String value;

    private CreateEmploymentApiModelWorkTimeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CreateEmploymentApiModelWorkTimeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CreateEmploymentApiModelWorkTimeValue
     */ 
    public static CreateEmploymentApiModelWorkTimeValue of(String value) {
        synchronized (CreateEmploymentApiModelWorkTimeValue.class) {
            return values.computeIfAbsent(value, v -> new CreateEmploymentApiModelWorkTimeValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<CreateEmploymentApiModelWorkTimeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CreateEmploymentApiModelWorkTimeValue other = (CreateEmploymentApiModelWorkTimeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CreateEmploymentApiModelWorkTimeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CreateEmploymentApiModelWorkTimeValue[] values() {
        synchronized (CreateEmploymentApiModelWorkTimeValue.class) {
            return values.values().toArray(new CreateEmploymentApiModelWorkTimeValue[] {});
        }
    }

    private static final Map<String, CreateEmploymentApiModelWorkTimeValue> createValuesMap() {
        Map<String, CreateEmploymentApiModelWorkTimeValue> map = new LinkedHashMap<>();
        map.put("day", DAY);
        map.put("week", WEEK);
        map.put("month", MONTH);
        map.put("year", YEAR);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CreateEmploymentApiModelWorkTimeValueEnum> createEnumsMap() {
        Map<String, CreateEmploymentApiModelWorkTimeValueEnum> map = new HashMap<>();
        map.put("day", CreateEmploymentApiModelWorkTimeValueEnum.DAY);
        map.put("week", CreateEmploymentApiModelWorkTimeValueEnum.WEEK);
        map.put("month", CreateEmploymentApiModelWorkTimeValueEnum.MONTH);
        map.put("year", CreateEmploymentApiModelWorkTimeValueEnum.YEAR);
        map.put("unmapped_value", CreateEmploymentApiModelWorkTimeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<CreateEmploymentApiModelWorkTimeValue> {

        protected _Serializer() {
            super(CreateEmploymentApiModelWorkTimeValue.class);
        }

        @Override
        public void serialize(CreateEmploymentApiModelWorkTimeValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<CreateEmploymentApiModelWorkTimeValue> {

        protected _Deserializer() {
            super(CreateEmploymentApiModelWorkTimeValue.class);
        }

        @Override
        public CreateEmploymentApiModelWorkTimeValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return CreateEmploymentApiModelWorkTimeValue.of(v);
        }
    }
    
    public enum CreateEmploymentApiModelWorkTimeValueEnum {

        DAY("day"),
        WEEK("week"),
        MONTH("month"),
        YEAR("year"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CreateEmploymentApiModelWorkTimeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

