/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisListEmployeeTimeOffRequestsQueryParamFilter
 * 
 * <p>HRIS Time Off filters
 */
public class HrisListEmployeeTimeOffRequestsQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * List of time off policy ids to filter by.
     */
    @SpeakeasyMetadata("queryParam:name=policy_ids")
    private JsonNullable<? extends List<String>> policyIds;

    @JsonCreator
    public HrisListEmployeeTimeOffRequestsQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<? extends List<String>> policyIds) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(policyIds, "policyIds");
        this.updatedAfter = updatedAfter;
        this.policyIds = policyIds;
    }
    
    public HrisListEmployeeTimeOffRequestsQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * List of time off policy ids to filter by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> policyIds() {
        return (JsonNullable<List<String>>) policyIds;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListEmployeeTimeOffRequestsQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListEmployeeTimeOffRequestsQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * List of time off policy ids to filter by.
     */
    public HrisListEmployeeTimeOffRequestsQueryParamFilter withPolicyIds(List<String> policyIds) {
        Utils.checkNotNull(policyIds, "policyIds");
        this.policyIds = JsonNullable.of(policyIds);
        return this;
    }

    /**
     * List of time off policy ids to filter by.
     */
    public HrisListEmployeeTimeOffRequestsQueryParamFilter withPolicyIds(JsonNullable<? extends List<String>> policyIds) {
        Utils.checkNotNull(policyIds, "policyIds");
        this.policyIds = policyIds;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeTimeOffRequestsQueryParamFilter other = (HrisListEmployeeTimeOffRequestsQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.policyIds, other.policyIds);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, policyIds);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListEmployeeTimeOffRequestsQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "policyIds", policyIds);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> policyIds = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * List of time off policy ids to filter by.
         */
        public Builder policyIds(List<String> policyIds) {
            Utils.checkNotNull(policyIds, "policyIds");
            this.policyIds = JsonNullable.of(policyIds);
            return this;
        }

        /**
         * List of time off policy ids to filter by.
         */
        public Builder policyIds(JsonNullable<? extends List<String>> policyIds) {
            Utils.checkNotNull(policyIds, "policyIds");
            this.policyIds = policyIds;
            return this;
        }

        public HrisListEmployeeTimeOffRequestsQueryParamFilter build() {

            return new HrisListEmployeeTimeOffRequestsQueryParamFilter(
                updatedAfter, policyIds);
        }

    }
}
