/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsUpdateJobRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsUpdateJobRequest;
import com.stackone.stackone_client_java.operations.AtsUpdateJob;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AtsUpdateJobRequestBuilder {

    private String xAccountId;
    private String id;
    private AtsUpdateJobRequestDto atsUpdateJobRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsUpdateJobRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsUpdateJobRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateJobRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateJobRequestBuilder atsUpdateJobRequestDto(AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
        this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
        return this;
    }
                
    public AtsUpdateJobRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsUpdateJobRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private AtsUpdateJobRequest buildRequest() {

        AtsUpdateJobRequest request = new AtsUpdateJobRequest(xAccountId,
            id,
            atsUpdateJobRequestDto);

        return request;
    }

    public CompletableFuture<AtsUpdateJobResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AtsUpdateJobRequest, AtsUpdateJobResponse> operation
              = new AtsUpdateJob.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        AtsUpdateJobRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
