/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;
import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.DownloadApiModel;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.PreconditionFailedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.AtsDownloadApplicationDocumentRequest;
import com.stackone.stackone_client_java.models.operations.AtsDownloadApplicationDocumentResponse;
import com.stackone.stackone_client_java.utils.AsyncRetries;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook.AfterErrorContextImpl;
import com.stackone.stackone_client_java.utils.Hook.AfterSuccessContextImpl;
import com.stackone.stackone_client_java.utils.Hook.BeforeRequestContextImpl;
import com.stackone.stackone_client_java.utils.NonRetryableException;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Exception;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.Throwable;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;


public class AtsDownloadApplicationDocument {

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;

        public Base(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            this.sdkConfiguration = sdkConfiguration;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options
                    .ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("429", "408");
            this.retryConfig = options
                    .flatMap(Options::retryConfig)
                    .or(sdkConfiguration::retryConfig)
                    .orElse(RetryConfig.builder().backoff(BackoffStrategy.builder()
                                    .initialInterval(500, TimeUnit.MILLISECONDS)
                                    .maxInterval(60000, TimeUnit.MILLISECONDS)
                                    .baseFactor((double) (1.5))
                                    .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                                    .retryConnectError(true)
                                    .build())
                            .build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        BeforeRequestContextImpl createBeforeRequestContext() {
            return new BeforeRequestContextImpl(
                    this.sdkConfiguration,
                    this.baseUrl,
                    "ats_download_application_document",
                    java.util.Optional.of(java.util.List.of()),
                    securitySource());
        }

        AfterSuccessContextImpl createAfterSuccessContext() {
            return new AfterSuccessContextImpl(
                    this.sdkConfiguration,
                    this.baseUrl,
                    "ats_download_application_document",
                    java.util.Optional.of(java.util.List.of()),
                    securitySource());
        }

        AfterErrorContextImpl createAfterErrorContext() {
            return new AfterErrorContextImpl(
                    this.sdkConfiguration,
                    this.baseUrl,
                    "ats_download_application_document",
                    java.util.Optional.of(java.util.List.of()),
                    securitySource());
        }
        <T>HttpRequest buildRequest(T request, Class<T> klass) throws Exception {
            String url = Utils.generateURL(
                    klass,
                    this.baseUrl,
                    "/unified/ats/applications/{id}/documents/{subResourceId}/download",
                    request, null);
            HTTPRequest req = new HTTPRequest(url, "GET");
            req.addHeader("Accept", "application/json;q=1, text/csv;q=0.97, text/plain;q=0.95, application/gzip;q=0.92, application/msword;q=0.89, application/octet-stream;q=0.87, application/pdf;q=0.84, application/rtf;q=0.82, application/vnd.ms-excel;q=0.79, application/vnd.ms-outlook;q=0.76, application/vnd.ms-powerpoint;q=0.74, application/vnd.oasis.opendocument.presentation;q=0.71, application/vnd.oasis.opendocument.spreadsheet;q=0.68, application/vnd.oasis.opendocument.text;q=0.66, application/vnd.openxmlformats-officedocument.presentationml.presentation;q=0.63, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;q=0.61, application/vnd.openxmlformats-officedocument.wordprocessingml.document;q=0.58, application/x-7z-compressed;q=0.55, application/x-rar-compressed;q=0.53, application/xml;q=0.50, application/zip;q=0.47, audio/mp4;q=0.45, audio/mpeg;q=0.42, audio/wav;q=0.39, image/bmp;q=0.37, image/gif;q=0.34, image/heic;q=0.32, image/jpeg;q=0.29, image/png;q=0.26, image/tiff;q=0.24, image/webp;q=0.21, message/rfc822;q=0.18, text/html;q=0.16, text/rtf;q=0.13, video/avi;q=0.11, video/mp4;q=0.08, video/quicktime;q=0.05, video/webm;q=0")
                    .addHeader("user-agent", SDKConfiguration.USER_AGENT);

            req.addQueryParams(Utils.getQueryParams(
                    klass,
                    request,
                    null));
            req.addHeaders(Utils.getHeadersFromMetadata(request, null));
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());

            return req.build();
        }
    }

    public static class Sync extends Base
            implements RequestOperation<AtsDownloadApplicationDocumentRequest, AtsDownloadApplicationDocumentResponse> {
        public Sync(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            super(sdkConfiguration, options);
        }

        private HttpRequest onBuildRequest(AtsDownloadApplicationDocumentRequest request) throws Exception {
            HttpRequest req = buildRequest(request, AtsDownloadApplicationDocumentRequest.class);
            return sdkConfiguration.hooks().beforeRequest(createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return sdkConfiguration.hooks().afterError(
                    createAfterErrorContext(),
                    Optional.ofNullable(response),
                    Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return sdkConfiguration.hooks().afterSuccess(createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(AtsDownloadApplicationDocumentRequest request) throws Exception {
            Retries retries = Retries.builder()
                    .action(() -> {
                        HttpRequest r;
                        try {
                            r = onBuildRequest(request);
                        } catch (Exception e) {
                            throw new NonRetryableException(e);
                        }
                        try {
                            HttpResponse<InputStream> httpRes = client.send(r);
                            if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "401", "403", "404", "408", "409", "412", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                                return onError(httpRes, null);
                            }
                            return httpRes;
                        } catch (Exception e) {
                            return onError(null, e);
                        }
                    })
                    .retryConfig(retryConfig)
                    .statusCodes(retryStatusCodes)
                    .build();
            return onSuccess(retries.run());
        }


        @Override
        public AtsDownloadApplicationDocumentResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
            String contentType = response
                    .headers()
                    .firstValue("Content-Type")
                    .orElse("application/octet-stream");
            AtsDownloadApplicationDocumentResponse.Builder resBuilder =
                    AtsDownloadApplicationDocumentResponse
                            .builder()
                            .contentType(contentType)
                            .statusCode(response.statusCode())
                            .rawResponse(response);

            AtsDownloadApplicationDocumentResponse res = resBuilder.build();
            
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/gzip")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/msword")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/octet-stream")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/pdf")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/rtf")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.ms-excel")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.ms-outlook")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.ms-powerpoint")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.presentation")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.spreadsheet")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.text")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/x-7z-compressed")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/x-rar-compressed")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/xml")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/zip")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "audio/mp4")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "audio/mpeg")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "audio/wav")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "image/bmp")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "image/gif")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "image/heic")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "image/jpeg")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "image/png")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "image/tiff")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "image/webp")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "message/rfc822")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "text/csv")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "text/html")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "text/rtf")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "video/avi")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "video/mp4")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "video/quicktime")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "video/webm")) {
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "text/plain")) {
                    String out = Utils.toUtf8AndClose(response.body());
                    res.withDownloadApiModel(out);
                    return res;
                } else if (Utils.contentTypeMatches(contentType, "application/json")) {
                    DownloadApiModel out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    res.withDownloadApiModel1(out);
                    return res;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    BadRequestResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    UnauthorizedResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ForbiddenResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    NotFoundResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    RequestTimedOutResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ConflictResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "412")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    PreconditionFailedResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    UnprocessableEntityResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    TooManyRequestsResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    InternalServerErrorResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    NotImplementedResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    BadGatewayResponse out = Utils.mapper().readValue(
                            response.body(),
                            new TypeReference<>() {
                            });
                    throw out;
                } else {
                    throw new SDKError(
                            response,
                            response.statusCode(),
                            "Unexpected content-type received: " + contentType,
                            Utils.extractByteArrayFromBody(response));
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                // no content
                throw new SDKError(
                        response,
                        response.statusCode(),
                        "API error occurred",
                        Utils.extractByteArrayFromBody(response));
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                // no content
                throw new SDKError(
                        response,
                        response.statusCode(),
                        "API error occurred",
                        Utils.extractByteArrayFromBody(response));
            }
            
            throw new SDKError(
                    response,
                    response.statusCode(),
                    "Unexpected status code received: " + response.statusCode(),
                    Utils.extractByteArrayFromBody(response));
        }
    }
    public static class Async extends Base
            implements AsyncRequestOperation<AtsDownloadApplicationDocumentRequest, com.stackone.stackone_client_java.models.operations.async.AtsDownloadApplicationDocumentResponse> {
        private final ScheduledExecutorService retryScheduler;

        public Async(
                SDKConfiguration sdkConfiguration, Optional<Options> options,
                ScheduledExecutorService retryScheduler) {
            super(sdkConfiguration, options);
            this.retryScheduler = retryScheduler;
        }

        private CompletableFuture<HttpRequest> onBuildRequest(AtsDownloadApplicationDocumentRequest request) throws Exception {
            HttpRequest req = buildRequest(request, AtsDownloadApplicationDocumentRequest.class);
            return this.sdkConfiguration.asyncHooks().beforeRequest(createBeforeRequestContext(), req);
        }

        private CompletableFuture<HttpResponse<Blob>> onError(HttpResponse<Blob> response, Throwable error) {
            return this.sdkConfiguration.asyncHooks().afterError(createAfterErrorContext(), response, error);
        }

        private CompletableFuture<HttpResponse<Blob>> onSuccess(HttpResponse<Blob> response) {
            return this.sdkConfiguration.asyncHooks().afterSuccess(createAfterSuccessContext(), response);
        }

        @Override
        public CompletableFuture<HttpResponse<Blob>> doRequest(AtsDownloadApplicationDocumentRequest request) {
            AsyncRetries retries = AsyncRetries.builder()
                    .retryConfig(retryConfig)
                    .statusCodes(retryStatusCodes)
                    .scheduler(retryScheduler)
                    .build();
            return retries.retry(() -> Exceptions.unchecked(() -> onBuildRequest(request)).get().thenCompose(client::sendAsync)
                            .handle((resp, err) -> {
                                if (err != null) {
                                    return onError(null, err);
                                }
                                if (Utils.statusCodeMatches(resp.statusCode(), "400", "401", "403", "404", "408", "409", "412", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                                    return onError(resp, null);
                                }
                                return CompletableFuture.completedFuture(resp);
                            })
                            .thenCompose(Function.identity()))
                    .thenCompose(this::onSuccess);
        }

        @Override
        public CompletableFuture<com.stackone.stackone_client_java.models.operations.async.AtsDownloadApplicationDocumentResponse> handleResponse(
                HttpResponse<Blob> response) {
            String contentType = response
                    .headers()
                    .firstValue("Content-Type")
                    .orElse("application/octet-stream");
            com.stackone.stackone_client_java.models.operations.async.AtsDownloadApplicationDocumentResponse.Builder resBuilder =
                    com.stackone.stackone_client_java.models.operations.async.AtsDownloadApplicationDocumentResponse
                            .builder()
                            .contentType(contentType)
                            .statusCode(response.statusCode())
                            .rawResponse(response);

            com.stackone.stackone_client_java.models.operations.async.AtsDownloadApplicationDocumentResponse res = resBuilder.build();
            
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/gzip")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/msword")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/octet-stream")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/pdf")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/rtf")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.ms-excel")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.ms-outlook")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.ms-powerpoint")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.presentation")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.spreadsheet")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.text")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/x-7z-compressed")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/x-rar-compressed")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/xml")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "application/zip")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "audio/mp4")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "audio/mpeg")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "audio/wav")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "image/bmp")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "image/gif")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "image/heic")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "image/jpeg")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "image/png")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "image/tiff")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "image/webp")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "message/rfc822")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "text/csv")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "text/html")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "text/rtf")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "video/avi")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "video/mp4")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "video/quicktime")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "video/webm")) {
                    return CompletableFuture.completedFuture(res);
                } else if (Utils.contentTypeMatches(contentType, "text/plain")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        try {
                            String out = new String(bodyBytes, StandardCharsets.UTF_8);
                            res.withDownloadApiModel(out);
                            return res;
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                } else if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        try {
                            DownloadApiModel out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                            res.withDownloadApiModel1(out);
                            return res;
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.BadRequestResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.UnauthorizedResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.ForbiddenResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.NotFoundResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.RequestTimedOutResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.ConflictResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "412")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.PreconditionFailedResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.UnprocessableEntityResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.TooManyRequestsResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.InternalServerErrorResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.NotImplementedResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.BadGatewayResponse out;
                        try {
                            out = Utils.mapper().readValue(
                                    bodyBytes,
                                    new TypeReference<>() {
                                    });
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                // no content
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                // no content
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            
            return Utils.createAsyncApiError(response, "Unexpected status code received: " + response.statusCode());
        }
    }
}
