/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.Id;
import com.stackone.stackone_client_java.models.components.Params;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class JsonRpcMessageDto {
    @JsonProperty(value="jsonrpc")
    private String jsonrpc;
    @JsonProperty(value="method")
    private String method;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="params")
    private Optional<? extends Params> params;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<? extends Id> id;

    @JsonCreator
    public JsonRpcMessageDto(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="params") Optional<? extends Params> params, @JsonProperty(value="id") Optional<? extends Id> id) {
        Utils.checkNotNull(jsonrpc, "jsonrpc");
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(params, "params");
        Utils.checkNotNull(id, "id");
        this.jsonrpc = jsonrpc;
        this.method = method;
        this.params = params;
        this.id = id;
    }

    public JsonRpcMessageDto(String jsonrpc, String method) {
        this(jsonrpc, method, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String jsonrpc() {
        return this.jsonrpc;
    }

    @JsonIgnore
    public String method() {
        return this.method;
    }

    @JsonIgnore
    public Optional<Params> params() {
        return this.params;
    }

    @JsonIgnore
    public Optional<Id> id() {
        return this.id;
    }

    public static Builder builder() {
        return new Builder();
    }

    public JsonRpcMessageDto withJsonrpc(String jsonrpc) {
        Utils.checkNotNull(jsonrpc, "jsonrpc");
        this.jsonrpc = jsonrpc;
        return this;
    }

    public JsonRpcMessageDto withMethod(String method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public JsonRpcMessageDto withParams(Params params) {
        Utils.checkNotNull(params, "params");
        this.params = Optional.ofNullable(params);
        return this;
    }

    public JsonRpcMessageDto withParams(Optional<? extends Params> params) {
        Utils.checkNotNull(params, "params");
        this.params = params;
        return this;
    }

    public JsonRpcMessageDto withId(Id id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public JsonRpcMessageDto withId(Optional<? extends Id> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRpcMessageDto other = (JsonRpcMessageDto)o;
        return Utils.enhancedDeepEquals(this.jsonrpc, other.jsonrpc) && Utils.enhancedDeepEquals(this.method, other.method) && Utils.enhancedDeepEquals(this.params, other.params) && Utils.enhancedDeepEquals(this.id, other.id);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.jsonrpc, this.method, this.params, this.id);
    }

    public String toString() {
        return Utils.toString(JsonRpcMessageDto.class, "jsonrpc", this.jsonrpc, "method", this.method, "params", this.params, "id", this.id);
    }

    public static final class Builder {
        private String jsonrpc;
        private String method;
        private Optional<? extends Params> params = Optional.empty();
        private Optional<? extends Id> id = Optional.empty();

        private Builder() {
        }

        public Builder jsonrpc(String jsonrpc) {
            Utils.checkNotNull(jsonrpc, "jsonrpc");
            this.jsonrpc = jsonrpc;
            return this;
        }

        public Builder method(String method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }

        public Builder params(Params params) {
            Utils.checkNotNull(params, "params");
            this.params = Optional.ofNullable(params);
            return this;
        }

        public Builder params(Optional<? extends Params> params) {
            Utils.checkNotNull(params, "params");
            this.params = params;
            return this;
        }

        public Builder id(Id id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<? extends Id> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public JsonRpcMessageDto build() {
            return new JsonRpcMessageDto(this.jsonrpc, this.method, this.params, this.id);
        }
    }
}

