/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MessagingListAttachmentsRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListAttachmentsResponse;
import com.stackone.stackone_client_java.operations.MessagingListAttachments;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class MessagingListAttachmentsRequestBuilder {
    private MessagingListAttachmentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public MessagingListAttachmentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MessagingListAttachmentsRequestBuilder request(MessagingListAttachmentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MessagingListAttachmentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MessagingListAttachmentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public MessagingListAttachmentsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListAttachments.Sync operation = new MessagingListAttachments.Sync(this.sdkConfiguration, options);
        return (MessagingListAttachmentsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<MessagingListAttachmentsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListAttachments.Sync operation = new MessagingListAttachments.Sync(this.sdkConfiguration, options);
        Paginator<MessagingListAttachmentsRequest, String> iterator = new Paginator<MessagingListAttachmentsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), MessagingListAttachmentsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<MessagingListAttachmentsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

