/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListApplicationDocumentsRequest;
import com.stackone.stackone_client_java.models.operations.async.AtsListApplicationDocumentsResponse;
import com.stackone.stackone_client_java.operations.AtsListApplicationDocuments;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class AtsListApplicationDocumentsRequestBuilder {
    private AtsListApplicationDocumentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsListApplicationDocumentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListApplicationDocumentsRequestBuilder request(AtsListApplicationDocumentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListApplicationDocumentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListApplicationDocumentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<AtsListApplicationDocumentsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListApplicationDocuments.Async operation = new AtsListApplicationDocuments.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<AtsListApplicationDocumentsResponse> callAsPublisher() {
        AtsListApplicationDocumentsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListApplicationDocuments.Async operation = new AtsListApplicationDocuments.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        AsyncPaginator<AtsListApplicationDocumentsRequest, String> asyncPaginator = new AsyncPaginator<AtsListApplicationDocumentsRequest, String>(request, new CursorTracker<String>("$.next", String.class), AtsListApplicationDocumentsRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

