/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsUpdateNotesRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsUpdateApplicationNoteRequest;
import com.stackone.stackone_client_java.models.operations.async.AtsUpdateApplicationNoteResponse;
import com.stackone.stackone_client_java.operations.AtsUpdateApplicationNote;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AtsUpdateApplicationNoteRequestBuilder {
    private String xAccountId;
    private String id;
    private String subResourceId;
    private AtsUpdateNotesRequestDto atsUpdateNotesRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsUpdateApplicationNoteRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsUpdateApplicationNoteRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateApplicationNoteRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateApplicationNoteRequestBuilder subResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    public AtsUpdateApplicationNoteRequestBuilder atsUpdateNotesRequestDto(AtsUpdateNotesRequestDto atsUpdateNotesRequestDto) {
        Utils.checkNotNull(atsUpdateNotesRequestDto, "atsUpdateNotesRequestDto");
        this.atsUpdateNotesRequestDto = atsUpdateNotesRequestDto;
        return this;
    }

    public AtsUpdateApplicationNoteRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsUpdateApplicationNoteRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsUpdateApplicationNoteRequest buildRequest() {
        AtsUpdateApplicationNoteRequest request = new AtsUpdateApplicationNoteRequest(this.xAccountId, this.id, this.subResourceId, this.atsUpdateNotesRequestDto);
        return request;
    }

    public CompletableFuture<AtsUpdateApplicationNoteResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsUpdateApplicationNote.Async operation = new AtsUpdateApplicationNote.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        AtsUpdateApplicationNoteRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

