/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.CrmListContactsRequest;
import com.stackone.stackone_client_java.models.operations.async.CrmListContactsResponse;
import com.stackone.stackone_client_java.operations.CrmListContacts;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class CrmListContactsRequestBuilder {
    private CrmListContactsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public CrmListContactsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CrmListContactsRequestBuilder request(CrmListContactsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public CrmListContactsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CrmListContactsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<CrmListContactsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmListContacts.Async operation = new CrmListContacts.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<CrmListContactsResponse> callAsPublisher() {
        CrmListContactsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmListContacts.Async operation = new CrmListContacts.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        AsyncPaginator<CrmListContactsRequest, String> asyncPaginator = new AsyncPaginator<CrmListContactsRequest, String>(request, new CursorTracker<String>("$.next", String.class), CrmListContactsRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

