/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneMcpPostRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=mcp-session-id")
    private Optional<String> mcpSessionId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private JsonRpcMessageDto jsonRpcMessageDto;

    @JsonCreator
    public StackoneMcpPostRequest(String xAccountId, Optional<String> mcpSessionId, JsonRpcMessageDto jsonRpcMessageDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
        this.xAccountId = xAccountId;
        this.mcpSessionId = mcpSessionId;
        this.jsonRpcMessageDto = jsonRpcMessageDto;
    }

    public StackoneMcpPostRequest(String xAccountId, JsonRpcMessageDto jsonRpcMessageDto) {
        this(xAccountId, Optional.empty(), jsonRpcMessageDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> mcpSessionId() {
        return this.mcpSessionId;
    }

    @JsonIgnore
    public JsonRpcMessageDto jsonRpcMessageDto() {
        return this.jsonRpcMessageDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneMcpPostRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneMcpPostRequest withMcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = Optional.ofNullable(mcpSessionId);
        return this;
    }

    public StackoneMcpPostRequest withMcpSessionId(Optional<String> mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    public StackoneMcpPostRequest withJsonRpcMessageDto(JsonRpcMessageDto jsonRpcMessageDto) {
        Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
        this.jsonRpcMessageDto = jsonRpcMessageDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpPostRequest other = (StackoneMcpPostRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.mcpSessionId, other.mcpSessionId) && Utils.enhancedDeepEquals(this.jsonRpcMessageDto, other.jsonRpcMessageDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.mcpSessionId, this.jsonRpcMessageDto);
    }

    public String toString() {
        return Utils.toString(StackoneMcpPostRequest.class, "xAccountId", this.xAccountId, "mcpSessionId", this.mcpSessionId, "jsonRpcMessageDto", this.jsonRpcMessageDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> mcpSessionId = Optional.empty();
        private JsonRpcMessageDto jsonRpcMessageDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder mcpSessionId(String mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = Optional.ofNullable(mcpSessionId);
            return this;
        }

        public Builder mcpSessionId(Optional<String> mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public Builder jsonRpcMessageDto(JsonRpcMessageDto jsonRpcMessageDto) {
            Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
            this.jsonRpcMessageDto = jsonRpcMessageDto;
            return this;
        }

        public StackoneMcpPostRequest build() {
            return new StackoneMcpPostRequest(this.xAccountId, this.mcpSessionId, this.jsonRpcMessageDto);
        }
    }
}

