/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class StackoneMcpPostRequest {
    /**
     * Account secure id for the target provider account
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Session id; omit for initialize, include for subsequent calls
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=mcp-session-id")
    private Optional<String> mcpSessionId;

    /**
     * JSON-RPC 2.0 message
     */
    @SpeakeasyMetadata("request:mediaType=application/json")
    private JsonRpcMessageDto jsonRpcMessageDto;

    @JsonCreator
    public StackoneMcpPostRequest(
            String xAccountId,
            Optional<String> mcpSessionId,
            JsonRpcMessageDto jsonRpcMessageDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
        this.xAccountId = xAccountId;
        this.mcpSessionId = mcpSessionId;
        this.jsonRpcMessageDto = jsonRpcMessageDto;
    }
    
    public StackoneMcpPostRequest(
            String xAccountId,
            JsonRpcMessageDto jsonRpcMessageDto) {
        this(xAccountId, Optional.empty(), jsonRpcMessageDto);
    }

    /**
     * Account secure id for the target provider account
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Session id; omit for initialize, include for subsequent calls
     */
    @JsonIgnore
    public Optional<String> mcpSessionId() {
        return mcpSessionId;
    }

    /**
     * JSON-RPC 2.0 message
     */
    @JsonIgnore
    public JsonRpcMessageDto jsonRpcMessageDto() {
        return jsonRpcMessageDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Account secure id for the target provider account
     */
    public StackoneMcpPostRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Session id; omit for initialize, include for subsequent calls
     */
    public StackoneMcpPostRequest withMcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = Optional.ofNullable(mcpSessionId);
        return this;
    }


    /**
     * Session id; omit for initialize, include for subsequent calls
     */
    public StackoneMcpPostRequest withMcpSessionId(Optional<String> mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    /**
     * JSON-RPC 2.0 message
     */
    public StackoneMcpPostRequest withJsonRpcMessageDto(JsonRpcMessageDto jsonRpcMessageDto) {
        Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
        this.jsonRpcMessageDto = jsonRpcMessageDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpPostRequest other = (StackoneMcpPostRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.mcpSessionId, other.mcpSessionId) &&
            Utils.enhancedDeepEquals(this.jsonRpcMessageDto, other.jsonRpcMessageDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, mcpSessionId, jsonRpcMessageDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneMcpPostRequest.class,
                "xAccountId", xAccountId,
                "mcpSessionId", mcpSessionId,
                "jsonRpcMessageDto", jsonRpcMessageDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> mcpSessionId = Optional.empty();

        private JsonRpcMessageDto jsonRpcMessageDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Account secure id for the target provider account
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Session id; omit for initialize, include for subsequent calls
         */
        public Builder mcpSessionId(String mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = Optional.ofNullable(mcpSessionId);
            return this;
        }

        /**
         * Session id; omit for initialize, include for subsequent calls
         */
        public Builder mcpSessionId(Optional<String> mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = mcpSessionId;
            return this;
        }


        /**
         * JSON-RPC 2.0 message
         */
        public Builder jsonRpcMessageDto(JsonRpcMessageDto jsonRpcMessageDto) {
            Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
            this.jsonRpcMessageDto = jsonRpcMessageDto;
            return this;
        }

        public StackoneMcpPostRequest build() {

            return new StackoneMcpPostRequest(
                xAccountId, mcpSessionId, jsonRpcMessageDto);
        }

    }
}
