/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.RoleType;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class Role {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="remote_id")
    private JsonNullable<String> remoteId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="label")
    private JsonNullable<String> label;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="role_type")
    private JsonNullable<? extends RoleType> roleType;

    @JsonCreator
    public Role(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="remote_id") JsonNullable<String> remoteId, @JsonProperty(value="label") JsonNullable<String> label, @JsonProperty(value="role_type") JsonNullable<? extends RoleType> roleType) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(roleType, "roleType");
        this.id = id;
        this.remoteId = remoteId;
        this.label = label;
        this.roleType = roleType;
    }

    public Role() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends RoleType>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return this.remoteId;
    }

    @JsonIgnore
    public JsonNullable<String> label() {
        return this.label;
    }

    @JsonIgnore
    public JsonNullable<RoleType> roleType() {
        return this.roleType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Role withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public Role withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Role withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of((Object)remoteId);
        return this;
    }

    public Role withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public Role withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of((Object)label);
        return this;
    }

    public Role withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    public Role withRoleType(RoleType roleType) {
        Utils.checkNotNull(roleType, "roleType");
        this.roleType = JsonNullable.of((Object)roleType);
        return this;
    }

    public Role withRoleType(JsonNullable<? extends RoleType> roleType) {
        Utils.checkNotNull(roleType, "roleType");
        this.roleType = roleType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role other = (Role)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.remoteId, other.remoteId) && Utils.enhancedDeepEquals(this.label, other.label) && Utils.enhancedDeepEquals(this.roleType, other.roleType);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.remoteId, this.label, this.roleType);
    }

    public String toString() {
        return Utils.toString(Role.class, "id", this.id, "remoteId", this.remoteId, "label", this.label, "roleType", this.roleType);
    }

    public static final class Builder {
        private JsonNullable<String> id = JsonNullable.undefined();
        private JsonNullable<String> remoteId = JsonNullable.undefined();
        private JsonNullable<String> label = JsonNullable.undefined();
        private JsonNullable<? extends RoleType> roleType = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of((Object)remoteId);
            return this;
        }

        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of((Object)label);
            return this;
        }

        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        public Builder roleType(RoleType roleType) {
            Utils.checkNotNull(roleType, "roleType");
            this.roleType = JsonNullable.of((Object)roleType);
            return this;
        }

        public Builder roleType(JsonNullable<? extends RoleType> roleType) {
            Utils.checkNotNull(roleType, "roleType");
            this.roleType = roleType;
            return this;
        }

        public Role build() {
            return new Role(this.id, this.remoteId, this.label, this.roleType);
        }
    }
}

