/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.WriteResultApiModel;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsUploadApplicationDocumentResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends WriteResultApiModel> writeResultApiModel;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsUploadApplicationDocumentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends WriteResultApiModel> writeResultApiModel, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.writeResultApiModel = writeResultApiModel;
        this.headers = headers;
    }

    public AtsUploadApplicationDocumentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WriteResultApiModel> writeResultApiModel() {
        return this.writeResultApiModel;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsUploadApplicationDocumentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsUploadApplicationDocumentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsUploadApplicationDocumentResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsUploadApplicationDocumentResponse withWriteResultApiModel(WriteResultApiModel writeResultApiModel) {
        Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
        this.writeResultApiModel = Optional.ofNullable(writeResultApiModel);
        return this;
    }

    public AtsUploadApplicationDocumentResponse withWriteResultApiModel(Optional<? extends WriteResultApiModel> writeResultApiModel) {
        Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
        this.writeResultApiModel = writeResultApiModel;
        return this;
    }

    public AtsUploadApplicationDocumentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsUploadApplicationDocumentResponse other = (AtsUploadApplicationDocumentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.writeResultApiModel, other.writeResultApiModel) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.writeResultApiModel, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsUploadApplicationDocumentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "writeResultApiModel", this.writeResultApiModel, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends WriteResultApiModel> writeResultApiModel = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder writeResultApiModel(WriteResultApiModel writeResultApiModel) {
            Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
            this.writeResultApiModel = Optional.ofNullable(writeResultApiModel);
            return this;
        }

        public Builder writeResultApiModel(Optional<? extends WriteResultApiModel> writeResultApiModel) {
            Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
            this.writeResultApiModel = writeResultApiModel;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsUploadApplicationDocumentResponse build() {
            return new AtsUploadApplicationDocumentResponse(this.contentType, this.statusCode, this.rawResponse, this.writeResultApiModel, this.headers);
        }
    }
}

