/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.IamListUsersRequest;
import com.stackone.stackone_client_java.models.operations.IamListUsersResponse;
import com.stackone.stackone_client_java.operations.IamListUsers;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class IamListUsersRequestBuilder {
    private IamListUsersRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public IamListUsersRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public IamListUsersRequestBuilder request(IamListUsersRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public IamListUsersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public IamListUsersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public IamListUsersResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        IamListUsers.Sync operation = new IamListUsers.Sync(this.sdkConfiguration, options, this._headers);
        return (IamListUsersResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<IamListUsersResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        IamListUsers.Sync operation = new IamListUsers.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<IamListUsersRequest, String> iterator = new Paginator<IamListUsersRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), IamListUsersRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<IamListUsersResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

