/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.HasSecurity;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class Security implements HasSecurity {

    @SpeakeasyMetadata("security:scheme=true,type=http,subtype=basic,name=username")
    private Optional<String> username;


    @SpeakeasyMetadata("security:scheme=true,type=http,subtype=basic,name=password")
    private Optional<String> password;

    @JsonCreator
    public Security(
            Optional<String> username,
            Optional<String> password) {
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(password, "password");
        this.username = username;
        this.password = password;
    }
    
    public Security() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> username() {
        return username;
    }

    @JsonIgnore
    public Optional<String> password() {
        return password;
    }

    public static Builder builder() {
        return new Builder();
    }


    public Security withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = Optional.ofNullable(username);
        return this;
    }


    public Security withUsername(Optional<String> username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    public Security withPassword(String password) {
        Utils.checkNotNull(password, "password");
        this.password = Optional.ofNullable(password);
        return this;
    }


    public Security withPassword(Optional<String> password) {
        Utils.checkNotNull(password, "password");
        this.password = password;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Security other = (Security) o;
        return 
            Utils.enhancedDeepEquals(this.username, other.username) &&
            Utils.enhancedDeepEquals(this.password, other.password);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            username, password);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Security.class,
                "username", username,
                "password", password);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> username = Optional.empty();

        private Optional<String> password = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = Optional.ofNullable(username);
            return this;
        }

        public Builder username(Optional<String> username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }


        public Builder password(String password) {
            Utils.checkNotNull(password, "password");
            this.password = Optional.ofNullable(password);
            return this;
        }

        public Builder password(Optional<String> password) {
            Utils.checkNotNull(password, "password");
            this.password = password;
            return this;
        }

        public Security build() {

            return new Security(
                username, password);
        }

    }
}
