/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteSecurity;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetSecurity;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostSecurity;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpDeleteRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpDeleteResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpGetRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpGetResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpPostRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpPostResponse;
import com.stackone.stackone_client_java.operations.StackoneMcpDelete;
import com.stackone.stackone_client_java.operations.StackoneMcpGet;
import com.stackone.stackone_client_java.operations.StackoneMcpPost;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.Object;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * Model Context Protocol endpoint.
 */
public class AsyncMcp {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Mcp syncSDK;

    AsyncMcp(Mcp syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Mcp sync() {
        return syncSDK;
    }


    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @return The async call builder
     */
    public StackoneMcpGetRequestBuilder mcpGet() {
        return new StackoneMcpGetRequestBuilder(sdkConfiguration);
    }

    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @param security The security details to use for authentication.
     * @param mcpSessionId Session id
     * @return {@code CompletableFuture<StackoneMcpGetResponse>} - The async response
     */
    public CompletableFuture<StackoneMcpGetResponse> mcpGet(StackoneMcpGetSecurity security, String mcpSessionId) {
        return mcpGet(
                security, Optional.empty(), Optional.empty(),
                mcpSessionId, Optional.empty());
    }

    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account (optional if x-account-id query parameter is provided)
     * @param xAccountIdQueryParameter Account secure id (alternative to x-account-id header)
     * @param mcpSessionId Session id
     * @param options additional options
     * @return {@code CompletableFuture<StackoneMcpGetResponse>} - The async response
     */
    public CompletableFuture<StackoneMcpGetResponse> mcpGet(
            StackoneMcpGetSecurity security, Optional<String> xAccountId,
            Optional<? extends Object> xAccountIdQueryParameter, String mcpSessionId,
            Optional<Options> options) {
        StackoneMcpGetRequest request =
            StackoneMcpGetRequest
                .builder()
                .xAccountId(xAccountId)
                .xAccountIdQueryParameter(xAccountIdQueryParameter)
                .mcpSessionId(mcpSessionId)
                .build();
        AsyncRequestOperation<StackoneMcpGetRequest, StackoneMcpGetResponse> operation
              = new StackoneMcpGet.Async(
                                    sdkConfiguration, security, options,
                                    sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @return The async call builder
     */
    public StackoneMcpPostRequestBuilder mcpPost() {
        return new StackoneMcpPostRequestBuilder(sdkConfiguration);
    }

    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @param security The security details to use for authentication.
     * @param jsonRpcMessageDto 
     * @return {@code CompletableFuture<StackoneMcpPostResponse>} - The async response
     */
    public CompletableFuture<StackoneMcpPostResponse> mcpPost(StackoneMcpPostSecurity security, JsonRpcMessageDto jsonRpcMessageDto) {
        return mcpPost(
                security, Optional.empty(), Optional.empty(),
                Optional.empty(), jsonRpcMessageDto, Optional.empty());
    }

    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account (optional if x-account-id query parameter is provided)
     * @param xAccountIdQueryParameter Account secure id (alternative to x-account-id header)
     * @param mcpSessionId Session id; omit for initialize, include for subsequent calls
     * @param jsonRpcMessageDto 
     * @param options additional options
     * @return {@code CompletableFuture<StackoneMcpPostResponse>} - The async response
     */
    public CompletableFuture<StackoneMcpPostResponse> mcpPost(
            StackoneMcpPostSecurity security, Optional<String> xAccountId,
            Optional<? extends Object> xAccountIdQueryParameter, Optional<String> mcpSessionId,
            JsonRpcMessageDto jsonRpcMessageDto, Optional<Options> options) {
        StackoneMcpPostRequest request =
            StackoneMcpPostRequest
                .builder()
                .xAccountId(xAccountId)
                .xAccountIdQueryParameter(xAccountIdQueryParameter)
                .mcpSessionId(mcpSessionId)
                .jsonRpcMessageDto(jsonRpcMessageDto)
                .build();
        AsyncRequestOperation<StackoneMcpPostRequest, StackoneMcpPostResponse> operation
              = new StackoneMcpPost.Async(
                                    sdkConfiguration, security, options,
                                    sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @return The async call builder
     */
    public StackoneMcpDeleteRequestBuilder mcpDelete() {
        return new StackoneMcpDeleteRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @param security The security details to use for authentication.
     * @param mcpSessionId Session id
     * @return {@code CompletableFuture<StackoneMcpDeleteResponse>} - The async response
     */
    public CompletableFuture<StackoneMcpDeleteResponse> mcpDelete(StackoneMcpDeleteSecurity security, String mcpSessionId) {
        return mcpDelete(
                security, Optional.empty(), Optional.empty(),
                mcpSessionId, Optional.empty());
    }

    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account (optional if x-account-id query parameter is provided)
     * @param xAccountIdQueryParameter Account secure id (alternative to x-account-id header)
     * @param mcpSessionId Session id
     * @param options additional options
     * @return {@code CompletableFuture<StackoneMcpDeleteResponse>} - The async response
     */
    public CompletableFuture<StackoneMcpDeleteResponse> mcpDelete(
            StackoneMcpDeleteSecurity security, Optional<String> xAccountId,
            Optional<? extends Object> xAccountIdQueryParameter, String mcpSessionId,
            Optional<Options> options) {
        StackoneMcpDeleteRequest request =
            StackoneMcpDeleteRequest
                .builder()
                .xAccountId(xAccountId)
                .xAccountIdQueryParameter(xAccountIdQueryParameter)
                .mcpSessionId(mcpSessionId)
                .build();
        AsyncRequestOperation<StackoneMcpDeleteRequest, StackoneMcpDeleteResponse> operation
              = new StackoneMcpDelete.Async(
                                    sdkConfiguration, security, options,
                                    sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
