/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * CreateAnswerType
 * 
 * <p>Type of the answer
 */
public class CreateAnswerType {
    /**
     * The type of the answer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends CreateAnswerValue> value;

    /**
     * The source value of the answer type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends CreateAnswerSourceValue> sourceValue;

    @JsonCreator
    public CreateAnswerType(
            @JsonProperty("value") JsonNullable<? extends CreateAnswerValue> value,
            @JsonProperty("source_value") JsonNullable<? extends CreateAnswerSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public CreateAnswerType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the answer.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateAnswerValue> value() {
        return (JsonNullable<CreateAnswerValue>) value;
    }

    /**
     * The source value of the answer type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateAnswerSourceValue> sourceValue() {
        return (JsonNullable<CreateAnswerSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The type of the answer.
     */
    public CreateAnswerType withValue(CreateAnswerValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the answer.
     */
    public CreateAnswerType withValue(JsonNullable<? extends CreateAnswerValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the answer type.
     */
    public CreateAnswerType withSourceValue(CreateAnswerSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the answer type.
     */
    public CreateAnswerType withSourceValue(JsonNullable<? extends CreateAnswerSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAnswerType other = (CreateAnswerType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateAnswerType.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends CreateAnswerValue> value = JsonNullable.undefined();

        private JsonNullable<? extends CreateAnswerSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The type of the answer.
         */
        public Builder value(CreateAnswerValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the answer.
         */
        public Builder value(JsonNullable<? extends CreateAnswerValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the answer type.
         */
        public Builder sourceValue(CreateAnswerSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the answer type.
         */
        public Builder sourceValue(JsonNullable<? extends CreateAnswerSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public CreateAnswerType build() {

            return new CreateAnswerType(
                value, sourceValue);
        }

    }
}
