/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class TicketingContent {
    /**
     * The content of the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("plain")
    private JsonNullable<String> plain;

    /**
     * The HTML content of the ticket
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("html")
    private JsonNullable<String> html;

    @JsonCreator
    public TicketingContent(
            @JsonProperty("plain") JsonNullable<String> plain,
            @JsonProperty("html") JsonNullable<String> html) {
        Utils.checkNotNull(plain, "plain");
        Utils.checkNotNull(html, "html");
        this.plain = plain;
        this.html = html;
    }
    
    public TicketingContent() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The content of the ticket
     */
    @JsonIgnore
    public JsonNullable<String> plain() {
        return plain;
    }

    /**
     * The HTML content of the ticket
     */
    @JsonIgnore
    public JsonNullable<String> html() {
        return html;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The content of the ticket
     */
    public TicketingContent withPlain(String plain) {
        Utils.checkNotNull(plain, "plain");
        this.plain = JsonNullable.of(plain);
        return this;
    }

    /**
     * The content of the ticket
     */
    public TicketingContent withPlain(JsonNullable<String> plain) {
        Utils.checkNotNull(plain, "plain");
        this.plain = plain;
        return this;
    }

    /**
     * The HTML content of the ticket
     */
    public TicketingContent withHtml(String html) {
        Utils.checkNotNull(html, "html");
        this.html = JsonNullable.of(html);
        return this;
    }

    /**
     * The HTML content of the ticket
     */
    public TicketingContent withHtml(JsonNullable<String> html) {
        Utils.checkNotNull(html, "html");
        this.html = html;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingContent other = (TicketingContent) o;
        return 
            Utils.enhancedDeepEquals(this.plain, other.plain) &&
            Utils.enhancedDeepEquals(this.html, other.html);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            plain, html);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingContent.class,
                "plain", plain,
                "html", html);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> plain = JsonNullable.undefined();

        private JsonNullable<String> html = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The content of the ticket
         */
        public Builder plain(String plain) {
            Utils.checkNotNull(plain, "plain");
            this.plain = JsonNullable.of(plain);
            return this;
        }

        /**
         * The content of the ticket
         */
        public Builder plain(JsonNullable<String> plain) {
            Utils.checkNotNull(plain, "plain");
            this.plain = plain;
            return this;
        }


        /**
         * The HTML content of the ticket
         */
        public Builder html(String html) {
            Utils.checkNotNull(html, "html");
            this.html = JsonNullable.of(html);
            return this;
        }

        /**
         * The HTML content of the ticket
         */
        public Builder html(JsonNullable<String> html) {
            Utils.checkNotNull(html, "html");
            this.html = html;
            return this;
        }

        public TicketingContent build() {

            return new TicketingContent(
                plain, html);
        }

    }
}
