/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * AccountingAccountValue
 * 
 * <p>Type of account
 */
public class AccountingAccountValue {

    public static final AccountingAccountValue ASSET = new AccountingAccountValue("asset");
    public static final AccountingAccountValue LIABILITY = new AccountingAccountValue("liability");
    public static final AccountingAccountValue EQUITY = new AccountingAccountValue("equity");
    public static final AccountingAccountValue REVENUE = new AccountingAccountValue("revenue");
    public static final AccountingAccountValue EXPENSE = new AccountingAccountValue("expense");
    public static final AccountingAccountValue UNMAPPED_VALUE = new AccountingAccountValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AccountingAccountValue> values = createValuesMap();
    private static final Map<String, AccountingAccountValueEnum> enums = createEnumsMap();

    private final String value;

    private AccountingAccountValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AccountingAccountValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AccountingAccountValue
     */ 
    @JsonCreator
    public static AccountingAccountValue of(String value) {
        synchronized (AccountingAccountValue.class) {
            return values.computeIfAbsent(value, v -> new AccountingAccountValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<AccountingAccountValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AccountingAccountValue other = (AccountingAccountValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AccountingAccountValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AccountingAccountValue[] values() {
        synchronized (AccountingAccountValue.class) {
            return values.values().toArray(new AccountingAccountValue[] {});
        }
    }

    private static final Map<String, AccountingAccountValue> createValuesMap() {
        Map<String, AccountingAccountValue> map = new LinkedHashMap<>();
        map.put("asset", ASSET);
        map.put("liability", LIABILITY);
        map.put("equity", EQUITY);
        map.put("revenue", REVENUE);
        map.put("expense", EXPENSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingAccountValueEnum> createEnumsMap() {
        Map<String, AccountingAccountValueEnum> map = new HashMap<>();
        map.put("asset", AccountingAccountValueEnum.ASSET);
        map.put("liability", AccountingAccountValueEnum.LIABILITY);
        map.put("equity", AccountingAccountValueEnum.EQUITY);
        map.put("revenue", AccountingAccountValueEnum.REVENUE);
        map.put("expense", AccountingAccountValueEnum.EXPENSE);
        map.put("unmapped_value", AccountingAccountValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum AccountingAccountValueEnum {

        ASSET("asset"),
        LIABILITY("liability"),
        EQUITY("equity"),
        REVENUE("revenue"),
        EXPENSE("expense"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AccountingAccountValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

