/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class ActionBuildResponseDto {
    /**
     * Build status
     */
    @JsonProperty("status")
    private ActionBuildResponseDtoStatus status;

    /**
     * Status message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message")
    private Optional<String> message;

    /**
     * Number of actions indexed (only for synchronous builds)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("actions_indexed")
    private Optional<Double> actionsIndexed;

    /**
     * Connector filter applied
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("connector_filter")
    private Optional<String> connectorFilter;

    /**
     * Error message if status is error
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("error")
    private Optional<String> error;

    @JsonCreator
    public ActionBuildResponseDto(
            @JsonProperty("status") ActionBuildResponseDtoStatus status,
            @JsonProperty("message") Optional<String> message,
            @JsonProperty("actions_indexed") Optional<Double> actionsIndexed,
            @JsonProperty("connector_filter") Optional<String> connectorFilter,
            @JsonProperty("error") Optional<String> error) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(actionsIndexed, "actionsIndexed");
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        Utils.checkNotNull(error, "error");
        this.status = status;
        this.message = message;
        this.actionsIndexed = actionsIndexed;
        this.connectorFilter = connectorFilter;
        this.error = error;
    }
    
    public ActionBuildResponseDto(
            ActionBuildResponseDtoStatus status) {
        this(status, Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty());
    }

    /**
     * Build status
     */
    @JsonIgnore
    public ActionBuildResponseDtoStatus status() {
        return status;
    }

    /**
     * Status message
     */
    @JsonIgnore
    public Optional<String> message() {
        return message;
    }

    /**
     * Number of actions indexed (only for synchronous builds)
     */
    @JsonIgnore
    public Optional<Double> actionsIndexed() {
        return actionsIndexed;
    }

    /**
     * Connector filter applied
     */
    @JsonIgnore
    public Optional<String> connectorFilter() {
        return connectorFilter;
    }

    /**
     * Error message if status is error
     */
    @JsonIgnore
    public Optional<String> error() {
        return error;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Build status
     */
    public ActionBuildResponseDto withStatus(ActionBuildResponseDtoStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Status message
     */
    public ActionBuildResponseDto withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = Optional.ofNullable(message);
        return this;
    }


    /**
     * Status message
     */
    public ActionBuildResponseDto withMessage(Optional<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    /**
     * Number of actions indexed (only for synchronous builds)
     */
    public ActionBuildResponseDto withActionsIndexed(double actionsIndexed) {
        Utils.checkNotNull(actionsIndexed, "actionsIndexed");
        this.actionsIndexed = Optional.ofNullable(actionsIndexed);
        return this;
    }


    /**
     * Number of actions indexed (only for synchronous builds)
     */
    public ActionBuildResponseDto withActionsIndexed(Optional<Double> actionsIndexed) {
        Utils.checkNotNull(actionsIndexed, "actionsIndexed");
        this.actionsIndexed = actionsIndexed;
        return this;
    }

    /**
     * Connector filter applied
     */
    public ActionBuildResponseDto withConnectorFilter(String connectorFilter) {
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        this.connectorFilter = Optional.ofNullable(connectorFilter);
        return this;
    }


    /**
     * Connector filter applied
     */
    public ActionBuildResponseDto withConnectorFilter(Optional<String> connectorFilter) {
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        this.connectorFilter = connectorFilter;
        return this;
    }

    /**
     * Error message if status is error
     */
    public ActionBuildResponseDto withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = Optional.ofNullable(error);
        return this;
    }


    /**
     * Error message if status is error
     */
    public ActionBuildResponseDto withError(Optional<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionBuildResponseDto other = (ActionBuildResponseDto) o;
        return 
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.message, other.message) &&
            Utils.enhancedDeepEquals(this.actionsIndexed, other.actionsIndexed) &&
            Utils.enhancedDeepEquals(this.connectorFilter, other.connectorFilter) &&
            Utils.enhancedDeepEquals(this.error, other.error);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            status, message, actionsIndexed,
            connectorFilter, error);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionBuildResponseDto.class,
                "status", status,
                "message", message,
                "actionsIndexed", actionsIndexed,
                "connectorFilter", connectorFilter,
                "error", error);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private ActionBuildResponseDtoStatus status;

        private Optional<String> message = Optional.empty();

        private Optional<Double> actionsIndexed = Optional.empty();

        private Optional<String> connectorFilter = Optional.empty();

        private Optional<String> error = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Build status
         */
        public Builder status(ActionBuildResponseDtoStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * Status message
         */
        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = Optional.ofNullable(message);
            return this;
        }

        /**
         * Status message
         */
        public Builder message(Optional<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }


        /**
         * Number of actions indexed (only for synchronous builds)
         */
        public Builder actionsIndexed(double actionsIndexed) {
            Utils.checkNotNull(actionsIndexed, "actionsIndexed");
            this.actionsIndexed = Optional.ofNullable(actionsIndexed);
            return this;
        }

        /**
         * Number of actions indexed (only for synchronous builds)
         */
        public Builder actionsIndexed(Optional<Double> actionsIndexed) {
            Utils.checkNotNull(actionsIndexed, "actionsIndexed");
            this.actionsIndexed = actionsIndexed;
            return this;
        }


        /**
         * Connector filter applied
         */
        public Builder connectorFilter(String connectorFilter) {
            Utils.checkNotNull(connectorFilter, "connectorFilter");
            this.connectorFilter = Optional.ofNullable(connectorFilter);
            return this;
        }

        /**
         * Connector filter applied
         */
        public Builder connectorFilter(Optional<String> connectorFilter) {
            Utils.checkNotNull(connectorFilter, "connectorFilter");
            this.connectorFilter = connectorFilter;
            return this;
        }


        /**
         * Error message if status is error
         */
        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = Optional.ofNullable(error);
            return this;
        }

        /**
         * Error message if status is error
         */
        public Builder error(Optional<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public ActionBuildResponseDto build() {

            return new ActionBuildResponseDto(
                status, message, actionsIndexed,
                connectorFilter, error);
        }

    }
}
