/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class ActionMetaItem {
    /**
     * The action ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The action label
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    /**
     * The action description
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The schema type for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("schema_type")
    private JsonNullable<String> schemaType;

    /**
     * The tags associated with this action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("tags")
    private JsonNullable<? extends List<String>> tags;

    /**
     * The authentication methods supported by this action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("authentication")
    private JsonNullable<? extends List<AuthenticationMetaItem>> authentication;

    /**
     * The action details for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("action_details")
    private JsonNullable<? extends Map<String, Object>> actionDetails;

    /**
     * The required scopes for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("required_scopes")
    private JsonNullable<? extends List<String>> requiredScopes;

    @JsonCreator
    public ActionMetaItem(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("schema_type") JsonNullable<String> schemaType,
            @JsonProperty("tags") JsonNullable<? extends List<String>> tags,
            @JsonProperty("authentication") JsonNullable<? extends List<AuthenticationMetaItem>> authentication,
            @JsonProperty("action_details") JsonNullable<? extends Map<String, Object>> actionDetails,
            @JsonProperty("required_scopes") JsonNullable<? extends List<String>> requiredScopes) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(schemaType, "schemaType");
        Utils.checkNotNull(tags, "tags");
        Utils.checkNotNull(authentication, "authentication");
        Utils.checkNotNull(actionDetails, "actionDetails");
        Utils.checkNotNull(requiredScopes, "requiredScopes");
        this.id = id;
        this.label = label;
        this.description = description;
        this.schemaType = schemaType;
        this.tags = tags;
        this.authentication = authentication;
        this.actionDetails = actionDetails;
        this.requiredScopes = requiredScopes;
    }
    
    public ActionMetaItem() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The action ID
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The action label
     */
    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    /**
     * The action description
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The schema type for the action
     */
    @JsonIgnore
    public JsonNullable<String> schemaType() {
        return schemaType;
    }

    /**
     * The tags associated with this action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> tags() {
        return (JsonNullable<List<String>>) tags;
    }

    /**
     * The authentication methods supported by this action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<AuthenticationMetaItem>> authentication() {
        return (JsonNullable<List<AuthenticationMetaItem>>) authentication;
    }

    /**
     * The action details for the action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> actionDetails() {
        return (JsonNullable<Map<String, Object>>) actionDetails;
    }

    /**
     * The required scopes for the action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> requiredScopes() {
        return (JsonNullable<List<String>>) requiredScopes;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The action ID
     */
    public ActionMetaItem withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The action ID
     */
    public ActionMetaItem withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The action label
     */
    public ActionMetaItem withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    /**
     * The action label
     */
    public ActionMetaItem withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    /**
     * The action description
     */
    public ActionMetaItem withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The action description
     */
    public ActionMetaItem withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The schema type for the action
     */
    public ActionMetaItem withSchemaType(String schemaType) {
        Utils.checkNotNull(schemaType, "schemaType");
        this.schemaType = JsonNullable.of(schemaType);
        return this;
    }

    /**
     * The schema type for the action
     */
    public ActionMetaItem withSchemaType(JsonNullable<String> schemaType) {
        Utils.checkNotNull(schemaType, "schemaType");
        this.schemaType = schemaType;
        return this;
    }

    /**
     * The tags associated with this action
     */
    public ActionMetaItem withTags(List<String> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = JsonNullable.of(tags);
        return this;
    }

    /**
     * The tags associated with this action
     */
    public ActionMetaItem withTags(JsonNullable<? extends List<String>> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = tags;
        return this;
    }

    /**
     * The authentication methods supported by this action
     */
    public ActionMetaItem withAuthentication(List<AuthenticationMetaItem> authentication) {
        Utils.checkNotNull(authentication, "authentication");
        this.authentication = JsonNullable.of(authentication);
        return this;
    }

    /**
     * The authentication methods supported by this action
     */
    public ActionMetaItem withAuthentication(JsonNullable<? extends List<AuthenticationMetaItem>> authentication) {
        Utils.checkNotNull(authentication, "authentication");
        this.authentication = authentication;
        return this;
    }

    /**
     * The action details for the action
     */
    public ActionMetaItem withActionDetails(Map<String, Object> actionDetails) {
        Utils.checkNotNull(actionDetails, "actionDetails");
        this.actionDetails = JsonNullable.of(actionDetails);
        return this;
    }

    /**
     * The action details for the action
     */
    public ActionMetaItem withActionDetails(JsonNullable<? extends Map<String, Object>> actionDetails) {
        Utils.checkNotNull(actionDetails, "actionDetails");
        this.actionDetails = actionDetails;
        return this;
    }

    /**
     * The required scopes for the action
     */
    public ActionMetaItem withRequiredScopes(List<String> requiredScopes) {
        Utils.checkNotNull(requiredScopes, "requiredScopes");
        this.requiredScopes = JsonNullable.of(requiredScopes);
        return this;
    }

    /**
     * The required scopes for the action
     */
    public ActionMetaItem withRequiredScopes(JsonNullable<? extends List<String>> requiredScopes) {
        Utils.checkNotNull(requiredScopes, "requiredScopes");
        this.requiredScopes = requiredScopes;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionMetaItem other = (ActionMetaItem) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.label, other.label) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.schemaType, other.schemaType) &&
            Utils.enhancedDeepEquals(this.tags, other.tags) &&
            Utils.enhancedDeepEquals(this.authentication, other.authentication) &&
            Utils.enhancedDeepEquals(this.actionDetails, other.actionDetails) &&
            Utils.enhancedDeepEquals(this.requiredScopes, other.requiredScopes);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, label, description,
            schemaType, tags, authentication,
            actionDetails, requiredScopes);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionMetaItem.class,
                "id", id,
                "label", label,
                "description", description,
                "schemaType", schemaType,
                "tags", tags,
                "authentication", authentication,
                "actionDetails", actionDetails,
                "requiredScopes", requiredScopes);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> label = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<String> schemaType = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> tags = JsonNullable.undefined();

        private JsonNullable<? extends List<AuthenticationMetaItem>> authentication = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> actionDetails = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> requiredScopes = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The action ID
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The action ID
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The action label
         */
        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        /**
         * The action label
         */
        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }


        /**
         * The action description
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The action description
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * The schema type for the action
         */
        public Builder schemaType(String schemaType) {
            Utils.checkNotNull(schemaType, "schemaType");
            this.schemaType = JsonNullable.of(schemaType);
            return this;
        }

        /**
         * The schema type for the action
         */
        public Builder schemaType(JsonNullable<String> schemaType) {
            Utils.checkNotNull(schemaType, "schemaType");
            this.schemaType = schemaType;
            return this;
        }


        /**
         * The tags associated with this action
         */
        public Builder tags(List<String> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = JsonNullable.of(tags);
            return this;
        }

        /**
         * The tags associated with this action
         */
        public Builder tags(JsonNullable<? extends List<String>> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = tags;
            return this;
        }


        /**
         * The authentication methods supported by this action
         */
        public Builder authentication(List<AuthenticationMetaItem> authentication) {
            Utils.checkNotNull(authentication, "authentication");
            this.authentication = JsonNullable.of(authentication);
            return this;
        }

        /**
         * The authentication methods supported by this action
         */
        public Builder authentication(JsonNullable<? extends List<AuthenticationMetaItem>> authentication) {
            Utils.checkNotNull(authentication, "authentication");
            this.authentication = authentication;
            return this;
        }


        /**
         * The action details for the action
         */
        public Builder actionDetails(Map<String, Object> actionDetails) {
            Utils.checkNotNull(actionDetails, "actionDetails");
            this.actionDetails = JsonNullable.of(actionDetails);
            return this;
        }

        /**
         * The action details for the action
         */
        public Builder actionDetails(JsonNullable<? extends Map<String, Object>> actionDetails) {
            Utils.checkNotNull(actionDetails, "actionDetails");
            this.actionDetails = actionDetails;
            return this;
        }


        /**
         * The required scopes for the action
         */
        public Builder requiredScopes(List<String> requiredScopes) {
            Utils.checkNotNull(requiredScopes, "requiredScopes");
            this.requiredScopes = JsonNullable.of(requiredScopes);
            return this;
        }

        /**
         * The required scopes for the action
         */
        public Builder requiredScopes(JsonNullable<? extends List<String>> requiredScopes) {
            Utils.checkNotNull(requiredScopes, "requiredScopes");
            this.requiredScopes = requiredScopes;
            return this;
        }

        public ActionMetaItem build() {

            return new ActionMetaItem(
                id, label, description,
                schemaType, tags, authentication,
                actionDetails, requiredScopes);
        }

    }
}
