/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * AssignmentLearningObjectTypeValue
 * 
 * <p>The StackOne unified learning object type.
 */
public class AssignmentLearningObjectTypeValue {

    public static final AssignmentLearningObjectTypeValue CONTENT = new AssignmentLearningObjectTypeValue("content");
    public static final AssignmentLearningObjectTypeValue COURSE = new AssignmentLearningObjectTypeValue("course");
    public static final AssignmentLearningObjectTypeValue COLLECTION = new AssignmentLearningObjectTypeValue("collection");
    public static final AssignmentLearningObjectTypeValue UNMAPPED_VALUE = new AssignmentLearningObjectTypeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AssignmentLearningObjectTypeValue> values = createValuesMap();
    private static final Map<String, AssignmentLearningObjectTypeValueEnum> enums = createEnumsMap();

    private final String value;

    private AssignmentLearningObjectTypeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AssignmentLearningObjectTypeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AssignmentLearningObjectTypeValue
     */ 
    @JsonCreator
    public static AssignmentLearningObjectTypeValue of(String value) {
        synchronized (AssignmentLearningObjectTypeValue.class) {
            return values.computeIfAbsent(value, v -> new AssignmentLearningObjectTypeValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<AssignmentLearningObjectTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AssignmentLearningObjectTypeValue other = (AssignmentLearningObjectTypeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AssignmentLearningObjectTypeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AssignmentLearningObjectTypeValue[] values() {
        synchronized (AssignmentLearningObjectTypeValue.class) {
            return values.values().toArray(new AssignmentLearningObjectTypeValue[] {});
        }
    }

    private static final Map<String, AssignmentLearningObjectTypeValue> createValuesMap() {
        Map<String, AssignmentLearningObjectTypeValue> map = new LinkedHashMap<>();
        map.put("content", CONTENT);
        map.put("course", COURSE);
        map.put("collection", COLLECTION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssignmentLearningObjectTypeValueEnum> createEnumsMap() {
        Map<String, AssignmentLearningObjectTypeValueEnum> map = new HashMap<>();
        map.put("content", AssignmentLearningObjectTypeValueEnum.CONTENT);
        map.put("course", AssignmentLearningObjectTypeValueEnum.COURSE);
        map.put("collection", AssignmentLearningObjectTypeValueEnum.COLLECTION);
        map.put("unmapped_value", AssignmentLearningObjectTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum AssignmentLearningObjectTypeValueEnum {

        CONTENT("content"),
        COURSE("course"),
        COLLECTION("collection"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AssignmentLearningObjectTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

