/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class GuideSectionMeta {
    /**
     * The title of the section
     */
    @JsonProperty("title")
    private String title;

    /**
     * The content of the section, includes markdown formatting
     */
    @JsonProperty("content")
    private String content;

    /**
     * List items for the section
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("list")
    private JsonNullable<? extends List<String>> list;

    /**
     * Nested steps within the section
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("steps")
    private JsonNullable<? extends List<GuideStepMeta>> steps;

    @JsonCreator
    public GuideSectionMeta(
            @JsonProperty("title") String title,
            @JsonProperty("content") String content,
            @JsonProperty("list") JsonNullable<? extends List<String>> list,
            @JsonProperty("steps") JsonNullable<? extends List<GuideStepMeta>> steps) {
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(list, "list");
        Utils.checkNotNull(steps, "steps");
        this.title = title;
        this.content = content;
        this.list = list;
        this.steps = steps;
    }
    
    public GuideSectionMeta(
            String title,
            String content) {
        this(title, content, JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * The title of the section
     */
    @JsonIgnore
    public String title() {
        return title;
    }

    /**
     * The content of the section, includes markdown formatting
     */
    @JsonIgnore
    public String content() {
        return content;
    }

    /**
     * List items for the section
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> list() {
        return (JsonNullable<List<String>>) list;
    }

    /**
     * Nested steps within the section
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<GuideStepMeta>> steps() {
        return (JsonNullable<List<GuideStepMeta>>) steps;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The title of the section
     */
    public GuideSectionMeta withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * The content of the section, includes markdown formatting
     */
    public GuideSectionMeta withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * List items for the section
     */
    public GuideSectionMeta withList(List<String> list) {
        Utils.checkNotNull(list, "list");
        this.list = JsonNullable.of(list);
        return this;
    }

    /**
     * List items for the section
     */
    public GuideSectionMeta withList(JsonNullable<? extends List<String>> list) {
        Utils.checkNotNull(list, "list");
        this.list = list;
        return this;
    }

    /**
     * Nested steps within the section
     */
    public GuideSectionMeta withSteps(List<GuideStepMeta> steps) {
        Utils.checkNotNull(steps, "steps");
        this.steps = JsonNullable.of(steps);
        return this;
    }

    /**
     * Nested steps within the section
     */
    public GuideSectionMeta withSteps(JsonNullable<? extends List<GuideStepMeta>> steps) {
        Utils.checkNotNull(steps, "steps");
        this.steps = steps;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GuideSectionMeta other = (GuideSectionMeta) o;
        return 
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.list, other.list) &&
            Utils.enhancedDeepEquals(this.steps, other.steps);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            title, content, list,
            steps);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GuideSectionMeta.class,
                "title", title,
                "content", content,
                "list", list,
                "steps", steps);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String title;

        private String content;

        private JsonNullable<? extends List<String>> list = JsonNullable.undefined();

        private JsonNullable<? extends List<GuideStepMeta>> steps = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The title of the section
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        /**
         * The content of the section, includes markdown formatting
         */
        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }


        /**
         * List items for the section
         */
        public Builder list(List<String> list) {
            Utils.checkNotNull(list, "list");
            this.list = JsonNullable.of(list);
            return this;
        }

        /**
         * List items for the section
         */
        public Builder list(JsonNullable<? extends List<String>> list) {
            Utils.checkNotNull(list, "list");
            this.list = list;
            return this;
        }


        /**
         * Nested steps within the section
         */
        public Builder steps(List<GuideStepMeta> steps) {
            Utils.checkNotNull(steps, "steps");
            this.steps = JsonNullable.of(steps);
            return this;
        }

        /**
         * Nested steps within the section
         */
        public Builder steps(JsonNullable<? extends List<GuideStepMeta>> steps) {
            Utils.checkNotNull(steps, "steps");
            this.steps = steps;
            return this;
        }

        public GuideSectionMeta build() {

            return new GuideSectionMeta(
                title, content, list,
                steps);
        }

    }
}
