/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class GuideStepMeta {
    /**
     * The title of the step
     */
    @JsonProperty("title")
    private String title;

    /**
     * The content of the step, includes markdown formatting
     */
    @JsonProperty("content")
    private String content;

    /**
     * List items for the step
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("list")
    private JsonNullable<? extends List<String>> list;

    @JsonCreator
    public GuideStepMeta(
            @JsonProperty("title") String title,
            @JsonProperty("content") String content,
            @JsonProperty("list") JsonNullable<? extends List<String>> list) {
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(list, "list");
        this.title = title;
        this.content = content;
        this.list = list;
    }
    
    public GuideStepMeta(
            String title,
            String content) {
        this(title, content, JsonNullable.undefined());
    }

    /**
     * The title of the step
     */
    @JsonIgnore
    public String title() {
        return title;
    }

    /**
     * The content of the step, includes markdown formatting
     */
    @JsonIgnore
    public String content() {
        return content;
    }

    /**
     * List items for the step
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> list() {
        return (JsonNullable<List<String>>) list;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The title of the step
     */
    public GuideStepMeta withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * The content of the step, includes markdown formatting
     */
    public GuideStepMeta withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * List items for the step
     */
    public GuideStepMeta withList(List<String> list) {
        Utils.checkNotNull(list, "list");
        this.list = JsonNullable.of(list);
        return this;
    }

    /**
     * List items for the step
     */
    public GuideStepMeta withList(JsonNullable<? extends List<String>> list) {
        Utils.checkNotNull(list, "list");
        this.list = list;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GuideStepMeta other = (GuideStepMeta) o;
        return 
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.list, other.list);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            title, content, list);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GuideStepMeta.class,
                "title", title,
                "content", content,
                "list", list);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String title;

        private String content;

        private JsonNullable<? extends List<String>> list = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The title of the step
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        /**
         * The content of the step, includes markdown formatting
         */
        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }


        /**
         * List items for the step
         */
        public Builder list(List<String> list) {
            Utils.checkNotNull(list, "list");
            this.list = JsonNullable.of(list);
            return this;
        }

        /**
         * List items for the step
         */
        public Builder list(JsonNullable<? extends List<String>> list) {
            Utils.checkNotNull(list, "list");
            this.list = list;
            return this;
        }

        public GuideStepMeta build() {

            return new GuideStepMeta(
                title, content, list);
        }

    }
}
