/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Guides
 * 
 * <p>Authentication guides for this authentication type
 */
public class Guides {
    /**
     * Configuration guide
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("config")
    private JsonNullable<? extends Config> config;

    /**
     * Account linking guide
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("setup")
    private JsonNullable<? extends Setup> setup;

    @JsonCreator
    public Guides(
            @JsonProperty("config") JsonNullable<? extends Config> config,
            @JsonProperty("setup") JsonNullable<? extends Setup> setup) {
        Utils.checkNotNull(config, "config");
        Utils.checkNotNull(setup, "setup");
        this.config = config;
        this.setup = setup;
    }
    
    public Guides() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Configuration guide
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Config> config() {
        return (JsonNullable<Config>) config;
    }

    /**
     * Account linking guide
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Setup> setup() {
        return (JsonNullable<Setup>) setup;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Configuration guide
     */
    public Guides withConfig(Config config) {
        Utils.checkNotNull(config, "config");
        this.config = JsonNullable.of(config);
        return this;
    }

    /**
     * Configuration guide
     */
    public Guides withConfig(JsonNullable<? extends Config> config) {
        Utils.checkNotNull(config, "config");
        this.config = config;
        return this;
    }

    /**
     * Account linking guide
     */
    public Guides withSetup(Setup setup) {
        Utils.checkNotNull(setup, "setup");
        this.setup = JsonNullable.of(setup);
        return this;
    }

    /**
     * Account linking guide
     */
    public Guides withSetup(JsonNullable<? extends Setup> setup) {
        Utils.checkNotNull(setup, "setup");
        this.setup = setup;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Guides other = (Guides) o;
        return 
            Utils.enhancedDeepEquals(this.config, other.config) &&
            Utils.enhancedDeepEquals(this.setup, other.setup);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            config, setup);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Guides.class,
                "config", config,
                "setup", setup);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends Config> config = JsonNullable.undefined();

        private JsonNullable<? extends Setup> setup = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Configuration guide
         */
        public Builder config(Config config) {
            Utils.checkNotNull(config, "config");
            this.config = JsonNullable.of(config);
            return this;
        }

        /**
         * Configuration guide
         */
        public Builder config(JsonNullable<? extends Config> config) {
            Utils.checkNotNull(config, "config");
            this.config = config;
            return this;
        }


        /**
         * Account linking guide
         */
        public Builder setup(Setup setup) {
            Utils.checkNotNull(setup, "setup");
            this.setup = JsonNullable.of(setup);
            return this;
        }

        /**
         * Account linking guide
         */
        public Builder setup(JsonNullable<? extends Setup> setup) {
            Utils.checkNotNull(setup, "setup");
            this.setup = setup;
            return this;
        }

        public Guides build() {

            return new Guides(
                config, setup);
        }

    }
}
