/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * HrisJobValue
 * 
 * <p>The status of the job.
 */
public class HrisJobValue {

    public static final HrisJobValue DRAFT = new HrisJobValue("draft");
    public static final HrisJobValue PENDING = new HrisJobValue("pending");
    public static final HrisJobValue ARCHIVED = new HrisJobValue("archived");
    public static final HrisJobValue CLOSED = new HrisJobValue("closed");
    public static final HrisJobValue OPEN = new HrisJobValue("open");
    public static final HrisJobValue DELETED = new HrisJobValue("deleted");
    public static final HrisJobValue UNMAPPED_VALUE = new HrisJobValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HrisJobValue> values = createValuesMap();
    private static final Map<String, HrisJobValueEnum> enums = createEnumsMap();

    private final String value;

    private HrisJobValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HrisJobValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HrisJobValue
     */ 
    @JsonCreator
    public static HrisJobValue of(String value) {
        synchronized (HrisJobValue.class) {
            return values.computeIfAbsent(value, v -> new HrisJobValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<HrisJobValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HrisJobValue other = (HrisJobValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HrisJobValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HrisJobValue[] values() {
        synchronized (HrisJobValue.class) {
            return values.values().toArray(new HrisJobValue[] {});
        }
    }

    private static final Map<String, HrisJobValue> createValuesMap() {
        Map<String, HrisJobValue> map = new LinkedHashMap<>();
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("archived", ARCHIVED);
        map.put("closed", CLOSED);
        map.put("open", OPEN);
        map.put("deleted", DELETED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HrisJobValueEnum> createEnumsMap() {
        Map<String, HrisJobValueEnum> map = new HashMap<>();
        map.put("draft", HrisJobValueEnum.DRAFT);
        map.put("pending", HrisJobValueEnum.PENDING);
        map.put("archived", HrisJobValueEnum.ARCHIVED);
        map.put("closed", HrisJobValueEnum.CLOSED);
        map.put("open", HrisJobValueEnum.OPEN);
        map.put("deleted", HrisJobValueEnum.DELETED);
        map.put("unmapped_value", HrisJobValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum HrisJobValueEnum {

        DRAFT("draft"),
        PENDING("pending"),
        ARCHIVED("archived"),
        CLOSED("closed"),
        OPEN("open"),
        DELETED("deleted"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private HrisJobValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

