/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * RejectedReasonValue
 * 
 * <p>The type of the rejected reason.
 */
public class RejectedReasonValue {

    public static final RejectedReasonValue REJECTED_BY_CANDIDATE = new RejectedReasonValue("rejected_by_candidate");
    public static final RejectedReasonValue REJECTED_BY_ORGANIZATION = new RejectedReasonValue("rejected_by_organization");
    public static final RejectedReasonValue OTHER = new RejectedReasonValue("other");
    public static final RejectedReasonValue UNKNOWN = new RejectedReasonValue("unknown");
    public static final RejectedReasonValue UNMAPPED_VALUE = new RejectedReasonValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, RejectedReasonValue> values = createValuesMap();
    private static final Map<String, RejectedReasonValueEnum> enums = createEnumsMap();

    private final String value;

    private RejectedReasonValue(String value) {
        this.value = value;
    }

    /**
     * Returns a RejectedReasonValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as RejectedReasonValue
     */ 
    @JsonCreator
    public static RejectedReasonValue of(String value) {
        synchronized (RejectedReasonValue.class) {
            return values.computeIfAbsent(value, v -> new RejectedReasonValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<RejectedReasonValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        RejectedReasonValue other = (RejectedReasonValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "RejectedReasonValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static RejectedReasonValue[] values() {
        synchronized (RejectedReasonValue.class) {
            return values.values().toArray(new RejectedReasonValue[] {});
        }
    }

    private static final Map<String, RejectedReasonValue> createValuesMap() {
        Map<String, RejectedReasonValue> map = new LinkedHashMap<>();
        map.put("rejected_by_candidate", REJECTED_BY_CANDIDATE);
        map.put("rejected_by_organization", REJECTED_BY_ORGANIZATION);
        map.put("other", OTHER);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, RejectedReasonValueEnum> createEnumsMap() {
        Map<String, RejectedReasonValueEnum> map = new HashMap<>();
        map.put("rejected_by_candidate", RejectedReasonValueEnum.REJECTED_BY_CANDIDATE);
        map.put("rejected_by_organization", RejectedReasonValueEnum.REJECTED_BY_ORGANIZATION);
        map.put("other", RejectedReasonValueEnum.OTHER);
        map.put("unknown", RejectedReasonValueEnum.UNKNOWN);
        map.put("unmapped_value", RejectedReasonValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum RejectedReasonValueEnum {

        REJECTED_BY_CANDIDATE("rejected_by_candidate"),
        REJECTED_BY_ORGANIZATION("rejected_by_organization"),
        OTHER("other"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private RejectedReasonValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

