/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class ScopeDefinitionMetaItem {
    /**
     * The scope name
     */
    @JsonProperty("name")
    private String name;

    /**
     * The scope description
     */
    @JsonProperty("description")
    private String description;

    /**
     * The scopes auto-included within this scope
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("includes")
    private JsonNullable<? extends List<String>> includes;

    @JsonCreator
    public ScopeDefinitionMetaItem(
            @JsonProperty("name") String name,
            @JsonProperty("description") String description,
            @JsonProperty("includes") JsonNullable<? extends List<String>> includes) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(includes, "includes");
        this.name = name;
        this.description = description;
        this.includes = includes;
    }
    
    public ScopeDefinitionMetaItem(
            String name,
            String description) {
        this(name, description, JsonNullable.undefined());
    }

    /**
     * The scope name
     */
    @JsonIgnore
    public String name() {
        return name;
    }

    /**
     * The scope description
     */
    @JsonIgnore
    public String description() {
        return description;
    }

    /**
     * The scopes auto-included within this scope
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> includes() {
        return (JsonNullable<List<String>>) includes;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The scope name
     */
    public ScopeDefinitionMetaItem withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The scope description
     */
    public ScopeDefinitionMetaItem withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The scopes auto-included within this scope
     */
    public ScopeDefinitionMetaItem withIncludes(List<String> includes) {
        Utils.checkNotNull(includes, "includes");
        this.includes = JsonNullable.of(includes);
        return this;
    }

    /**
     * The scopes auto-included within this scope
     */
    public ScopeDefinitionMetaItem withIncludes(JsonNullable<? extends List<String>> includes) {
        Utils.checkNotNull(includes, "includes");
        this.includes = includes;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScopeDefinitionMetaItem other = (ScopeDefinitionMetaItem) o;
        return 
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.includes, other.includes);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            name, description, includes);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ScopeDefinitionMetaItem.class,
                "name", name,
                "description", description,
                "includes", includes);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String name;

        private String description;

        private JsonNullable<? extends List<String>> includes = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The scope name
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The scope description
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * The scopes auto-included within this scope
         */
        public Builder includes(List<String> includes) {
            Utils.checkNotNull(includes, "includes");
            this.includes = JsonNullable.of(includes);
            return this;
        }

        /**
         * The scopes auto-included within this scope
         */
        public Builder includes(JsonNullable<? extends List<String>> includes) {
            Utils.checkNotNull(includes, "includes");
            this.includes = includes;
            return this;
        }

        public ScopeDefinitionMetaItem build() {

            return new ScopeDefinitionMetaItem(
                name, description, includes);
        }

    }
}
