/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Setup
 * 
 * <p>Account linking guide
 */
public class Setup {
    /**
     * Warning text for the guide
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("warning")
    private JsonNullable<String> warning;

    /**
     * The guide sections
     */
    @JsonProperty("sections")
    private List<GuideSectionMeta> sections;

    @JsonCreator
    public Setup(
            @JsonProperty("warning") JsonNullable<String> warning,
            @JsonProperty("sections") List<GuideSectionMeta> sections) {
        Utils.checkNotNull(warning, "warning");
        Utils.checkNotNull(sections, "sections");
        this.warning = warning;
        this.sections = sections;
    }
    
    public Setup(
            List<GuideSectionMeta> sections) {
        this(JsonNullable.undefined(), sections);
    }

    /**
     * Warning text for the guide
     */
    @JsonIgnore
    public JsonNullable<String> warning() {
        return warning;
    }

    /**
     * The guide sections
     */
    @JsonIgnore
    public List<GuideSectionMeta> sections() {
        return sections;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Warning text for the guide
     */
    public Setup withWarning(String warning) {
        Utils.checkNotNull(warning, "warning");
        this.warning = JsonNullable.of(warning);
        return this;
    }

    /**
     * Warning text for the guide
     */
    public Setup withWarning(JsonNullable<String> warning) {
        Utils.checkNotNull(warning, "warning");
        this.warning = warning;
        return this;
    }

    /**
     * The guide sections
     */
    public Setup withSections(List<GuideSectionMeta> sections) {
        Utils.checkNotNull(sections, "sections");
        this.sections = sections;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Setup other = (Setup) o;
        return 
            Utils.enhancedDeepEquals(this.warning, other.warning) &&
            Utils.enhancedDeepEquals(this.sections, other.sections);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            warning, sections);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Setup.class,
                "warning", warning,
                "sections", sections);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> warning = JsonNullable.undefined();

        private List<GuideSectionMeta> sections;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Warning text for the guide
         */
        public Builder warning(String warning) {
            Utils.checkNotNull(warning, "warning");
            this.warning = JsonNullable.of(warning);
            return this;
        }

        /**
         * Warning text for the guide
         */
        public Builder warning(JsonNullable<String> warning) {
            Utils.checkNotNull(warning, "warning");
            this.warning = warning;
            return this;
        }


        /**
         * The guide sections
         */
        public Builder sections(List<GuideSectionMeta> sections) {
            Utils.checkNotNull(sections, "sections");
            this.sections = sections;
            return this;
        }

        public Setup build() {

            return new Setup(
                warning, sections);
        }

    }
}
