/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Support
 * 
 * <p>The support information for this authentication method, including configuration and account linking
 * guides
 */
public class Support {
    /**
     * Link to support documentation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("link")
    private JsonNullable<String> link;

    /**
     * Support description
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * Authentication guides for this authentication type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("guides")
    private JsonNullable<? extends Guides> guides;

    @JsonCreator
    public Support(
            @JsonProperty("link") JsonNullable<String> link,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("guides") JsonNullable<? extends Guides> guides) {
        Utils.checkNotNull(link, "link");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(guides, "guides");
        this.link = link;
        this.description = description;
        this.guides = guides;
    }
    
    public Support() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Link to support documentation
     */
    @JsonIgnore
    public JsonNullable<String> link() {
        return link;
    }

    /**
     * Support description
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * Authentication guides for this authentication type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Guides> guides() {
        return (JsonNullable<Guides>) guides;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Link to support documentation
     */
    public Support withLink(String link) {
        Utils.checkNotNull(link, "link");
        this.link = JsonNullable.of(link);
        return this;
    }

    /**
     * Link to support documentation
     */
    public Support withLink(JsonNullable<String> link) {
        Utils.checkNotNull(link, "link");
        this.link = link;
        return this;
    }

    /**
     * Support description
     */
    public Support withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * Support description
     */
    public Support withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * Authentication guides for this authentication type
     */
    public Support withGuides(Guides guides) {
        Utils.checkNotNull(guides, "guides");
        this.guides = JsonNullable.of(guides);
        return this;
    }

    /**
     * Authentication guides for this authentication type
     */
    public Support withGuides(JsonNullable<? extends Guides> guides) {
        Utils.checkNotNull(guides, "guides");
        this.guides = guides;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Support other = (Support) o;
        return 
            Utils.enhancedDeepEquals(this.link, other.link) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.guides, other.guides);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            link, description, guides);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Support.class,
                "link", link,
                "description", description,
                "guides", guides);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> link = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<? extends Guides> guides = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Link to support documentation
         */
        public Builder link(String link) {
            Utils.checkNotNull(link, "link");
            this.link = JsonNullable.of(link);
            return this;
        }

        /**
         * Link to support documentation
         */
        public Builder link(JsonNullable<String> link) {
            Utils.checkNotNull(link, "link");
            this.link = link;
            return this;
        }


        /**
         * Support description
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * Support description
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * Authentication guides for this authentication type
         */
        public Builder guides(Guides guides) {
            Utils.checkNotNull(guides, "guides");
            this.guides = JsonNullable.of(guides);
            return this;
        }

        /**
         * Authentication guides for this authentication type
         */
        public Builder guides(JsonNullable<? extends Guides> guides) {
            Utils.checkNotNull(guides, "guides");
            this.guides = guides;
            return this;
        }

        public Support build() {

            return new Support(
                link, description, guides);
        }

    }
}
