/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * TaskResultValue
 * 
 * <p>The unified value for the type of the task. If the provider does not specify this type, the value
 * will be set to UnmappedValue
 */
public class TaskResultValue {

    public static final TaskResultValue ACTION = new TaskResultValue("action");
    public static final TaskResultValue REVIEW = new TaskResultValue("review");
    public static final TaskResultValue ACKNOWLEDGMENT = new TaskResultValue("acknowledgment");
    public static final TaskResultValue EDIT = new TaskResultValue("edit");
    public static final TaskResultValue APPROVE = new TaskResultValue("approve");
    public static final TaskResultValue UNMAPPED_VALUE = new TaskResultValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TaskResultValue> values = createValuesMap();
    private static final Map<String, TaskResultValueEnum> enums = createEnumsMap();

    private final String value;

    private TaskResultValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TaskResultValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TaskResultValue
     */ 
    @JsonCreator
    public static TaskResultValue of(String value) {
        synchronized (TaskResultValue.class) {
            return values.computeIfAbsent(value, v -> new TaskResultValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TaskResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TaskResultValue other = (TaskResultValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TaskResultValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TaskResultValue[] values() {
        synchronized (TaskResultValue.class) {
            return values.values().toArray(new TaskResultValue[] {});
        }
    }

    private static final Map<String, TaskResultValue> createValuesMap() {
        Map<String, TaskResultValue> map = new LinkedHashMap<>();
        map.put("action", ACTION);
        map.put("review", REVIEW);
        map.put("acknowledgment", ACKNOWLEDGMENT);
        map.put("edit", EDIT);
        map.put("approve", APPROVE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskResultValueEnum> createEnumsMap() {
        Map<String, TaskResultValueEnum> map = new HashMap<>();
        map.put("action", TaskResultValueEnum.ACTION);
        map.put("review", TaskResultValueEnum.REVIEW);
        map.put("acknowledgment", TaskResultValueEnum.ACKNOWLEDGMENT);
        map.put("edit", TaskResultValueEnum.EDIT);
        map.put("approve", TaskResultValueEnum.APPROVE);
        map.put("unmapped_value", TaskResultValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum TaskResultValueEnum {

        ACTION("action"),
        REVIEW("review"),
        ACKNOWLEDGMENT("acknowledgment"),
        EDIT("edit"),
        APPROVE("approve"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TaskResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

