/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * TicketingUserResultValue
 * 
 * <p>The type of the user.
 */
public class TicketingUserResultValue {

    public static final TicketingUserResultValue AGENT = new TicketingUserResultValue("agent");
    public static final TicketingUserResultValue CONTACT = new TicketingUserResultValue("contact");
    public static final TicketingUserResultValue BOT = new TicketingUserResultValue("bot");
    public static final TicketingUserResultValue UNMAPPED_VALUE = new TicketingUserResultValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TicketingUserResultValue> values = createValuesMap();
    private static final Map<String, TicketingUserResultValueEnum> enums = createEnumsMap();

    private final String value;

    private TicketingUserResultValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TicketingUserResultValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TicketingUserResultValue
     */ 
    @JsonCreator
    public static TicketingUserResultValue of(String value) {
        synchronized (TicketingUserResultValue.class) {
            return values.computeIfAbsent(value, v -> new TicketingUserResultValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TicketingUserResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TicketingUserResultValue other = (TicketingUserResultValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TicketingUserResultValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TicketingUserResultValue[] values() {
        synchronized (TicketingUserResultValue.class) {
            return values.values().toArray(new TicketingUserResultValue[] {});
        }
    }

    private static final Map<String, TicketingUserResultValue> createValuesMap() {
        Map<String, TicketingUserResultValue> map = new LinkedHashMap<>();
        map.put("agent", AGENT);
        map.put("contact", CONTACT);
        map.put("bot", BOT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingUserResultValueEnum> createEnumsMap() {
        Map<String, TicketingUserResultValueEnum> map = new HashMap<>();
        map.put("agent", TicketingUserResultValueEnum.AGENT);
        map.put("contact", TicketingUserResultValueEnum.CONTACT);
        map.put("bot", TicketingUserResultValueEnum.BOT);
        map.put("unmapped_value", TicketingUserResultValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum TicketingUserResultValueEnum {

        AGENT("agent"),
        CONTACT("contact"),
        BOT("bot"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TicketingUserResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

