/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * Type
 * 
 * <p>The connect session account type
 */
public class Type {

    public static final Type PRODUCTION = new Type("production");
    public static final Type TEST = new Type("test");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, Type> values = createValuesMap();
    private static final Map<String, TypeEnum> enums = createEnumsMap();

    private final String value;

    private Type(String value) {
        this.value = value;
    }

    /**
     * Returns a Type with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as Type
     */ 
    @JsonCreator
    public static Type of(String value) {
        synchronized (Type.class) {
            return values.computeIfAbsent(value, v -> new Type(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Type other = (Type) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "Type [value=" + value + "]";
    }

    // return an array just like an enum
    public static Type[] values() {
        synchronized (Type.class) {
            return values.values().toArray(new Type[] {});
        }
    }

    private static final Map<String, Type> createValuesMap() {
        Map<String, Type> map = new LinkedHashMap<>();
        map.put("production", PRODUCTION);
        map.put("test", TEST);
        return map;
    }

    private static final Map<String, TypeEnum> createEnumsMap() {
        Map<String, TypeEnum> map = new HashMap<>();
        map.put("production", TypeEnum.PRODUCTION);
        map.put("test", TypeEnum.TEST);
        return map;
    }
    
    
    public enum TypeEnum {

        PRODUCTION("production"),
        TEST("test"),;

        private final String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

