/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateApplicationRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AtsCreateApplicationRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AtsCreateApplicationRequestDto atsCreateApplicationRequestDto;

    @JsonCreator
    public AtsCreateApplicationRequest(
            String xAccountId,
            Optional<String> prefer,
            AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
    }
    
    public AtsCreateApplicationRequest(
            String xAccountId,
            AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateApplicationRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public AtsCreateApplicationRequestDto atsCreateApplicationRequestDto() {
        return atsCreateApplicationRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AtsCreateApplicationRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateApplicationRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateApplicationRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateApplicationRequest withAtsCreateApplicationRequestDto(AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
        Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
        this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsCreateApplicationRequest other = (AtsCreateApplicationRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.atsCreateApplicationRequestDto, other.atsCreateApplicationRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, atsCreateApplicationRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsCreateApplicationRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "atsCreateApplicationRequestDto", atsCreateApplicationRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private AtsCreateApplicationRequestDto atsCreateApplicationRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder atsCreateApplicationRequestDto(AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
            Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
            this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
            return this;
        }

        public AtsCreateApplicationRequest build() {

            return new AtsCreateApplicationRequest(
                xAccountId, prefer, atsCreateApplicationRequestDto);
        }

    }
}
