/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateJobRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AtsCreateJobRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AtsCreateJobRequestDto atsCreateJobRequestDto;

    @JsonCreator
    public AtsCreateJobRequest(
            String xAccountId,
            Optional<String> prefer,
            AtsCreateJobRequestDto atsCreateJobRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateJobRequestDto = atsCreateJobRequestDto;
    }
    
    public AtsCreateJobRequest(
            String xAccountId,
            AtsCreateJobRequestDto atsCreateJobRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateJobRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public AtsCreateJobRequestDto atsCreateJobRequestDto() {
        return atsCreateJobRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AtsCreateJobRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateJobRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateJobRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateJobRequest withAtsCreateJobRequestDto(AtsCreateJobRequestDto atsCreateJobRequestDto) {
        Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
        this.atsCreateJobRequestDto = atsCreateJobRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsCreateJobRequest other = (AtsCreateJobRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.atsCreateJobRequestDto, other.atsCreateJobRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, atsCreateJobRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsCreateJobRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "atsCreateJobRequestDto", atsCreateJobRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private AtsCreateJobRequestDto atsCreateJobRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder atsCreateJobRequestDto(AtsCreateJobRequestDto atsCreateJobRequestDto) {
            Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
            this.atsCreateJobRequestDto = atsCreateJobRequestDto;
            return this;
        }

        public AtsCreateJobRequest build() {

            return new AtsCreateJobRequest(
                xAccountId, prefer, atsCreateJobRequestDto);
        }

    }
}
