/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisCreateWorkEligibilityRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class HrisCreateEmployeeWorkEligibilityRequestRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private HrisCreateWorkEligibilityRequestDto hrisCreateWorkEligibilityRequestDto;

    @JsonCreator
    public HrisCreateEmployeeWorkEligibilityRequestRequest(
            String id,
            String xAccountId,
            Optional<String> prefer,
            HrisCreateWorkEligibilityRequestDto hrisCreateWorkEligibilityRequestDto) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisCreateWorkEligibilityRequestDto, "hrisCreateWorkEligibilityRequestDto");
        this.id = id;
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.hrisCreateWorkEligibilityRequestDto = hrisCreateWorkEligibilityRequestDto;
    }
    
    public HrisCreateEmployeeWorkEligibilityRequestRequest(
            String id,
            String xAccountId,
            HrisCreateWorkEligibilityRequestDto hrisCreateWorkEligibilityRequestDto) {
        this(id, xAccountId, Optional.empty(),
            hrisCreateWorkEligibilityRequestDto);
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public HrisCreateWorkEligibilityRequestDto hrisCreateWorkEligibilityRequestDto() {
        return hrisCreateWorkEligibilityRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    public HrisCreateEmployeeWorkEligibilityRequestRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The account identifier
     */
    public HrisCreateEmployeeWorkEligibilityRequestRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisCreateEmployeeWorkEligibilityRequestRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisCreateEmployeeWorkEligibilityRequestRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisCreateEmployeeWorkEligibilityRequestRequest withHrisCreateWorkEligibilityRequestDto(HrisCreateWorkEligibilityRequestDto hrisCreateWorkEligibilityRequestDto) {
        Utils.checkNotNull(hrisCreateWorkEligibilityRequestDto, "hrisCreateWorkEligibilityRequestDto");
        this.hrisCreateWorkEligibilityRequestDto = hrisCreateWorkEligibilityRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisCreateEmployeeWorkEligibilityRequestRequest other = (HrisCreateEmployeeWorkEligibilityRequestRequest) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.hrisCreateWorkEligibilityRequestDto, other.hrisCreateWorkEligibilityRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, xAccountId, prefer,
            hrisCreateWorkEligibilityRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisCreateEmployeeWorkEligibilityRequestRequest.class,
                "id", id,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "hrisCreateWorkEligibilityRequestDto", hrisCreateWorkEligibilityRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String id;

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private HrisCreateWorkEligibilityRequestDto hrisCreateWorkEligibilityRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder hrisCreateWorkEligibilityRequestDto(HrisCreateWorkEligibilityRequestDto hrisCreateWorkEligibilityRequestDto) {
            Utils.checkNotNull(hrisCreateWorkEligibilityRequestDto, "hrisCreateWorkEligibilityRequestDto");
            this.hrisCreateWorkEligibilityRequestDto = hrisCreateWorkEligibilityRequestDto;
            return this;
        }

        public HrisCreateEmployeeWorkEligibilityRequestRequest build() {

            return new HrisCreateEmployeeWorkEligibilityRequestRequest(
                id, xAccountId, prefer,
                hrisCreateWorkEligibilityRequestDto);
        }

    }
}
