/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.Locale;
import java.util.function.BiConsumer;

// Internal API only

/**
 * Encapsulates HTTP headers. Header names are case-insensitive.
 */
public final class Headers {

    public static final Headers EMPTY = new Headers(Collections.emptyMap());

    // keys are lowercased
    private final Map<String, List<String>> map;

    // Internal use only
    public Headers(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.map = headers //
                .entrySet() //
                .stream() //
                .map(entry -> Map.entry(entry.getKey().toLowerCase(Locale.ENGLISH), entry.getValue())) //
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    // Internal use only
    public Headers() {
        this(new HashMap<>());
    }

    /**
     * Returns all values for a header name. Header name is case-insensitive.
     * 
     * @param name header name
     * @return all values for the header name
     */
    public List<String> get(String name) {
        Utils.checkNotNull(name, "name");
        return Collections.unmodifiableList(values(name));
    }

    /**
     * Returns the first value for a header name. Header name is case-insensitive.
     * 
     * @param name header name
     * @return the first value for the header name
     */
    public Optional<String> first(String name) {
        Utils.checkNotNull(name, "name");
        return values(name).stream().findFirst();
    }

    /**
     * Appends a header value. Header name is case-insensitive.
     * 
     * @param name  header name
     * @param value header value
     * @return this
     */
    public Headers add(String name, String value) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(value, "value");
        List<String> values = values(name);
        if (values.isEmpty()) {
            List<String> list = new ArrayList<>();
            list.add(value);
            map.put(name.toLowerCase(Locale.ENGLISH), list);
        } else {
            values.add(value);
        }
        return this;
    }
    
    public Headers add(Headers headers) {
        Utils.checkNotNull(headers, "headers");
        headers
            .forEach((key, values) -> values.forEach(value -> add(key, value)));
        return this;
    }
    
    public void forEach(BiConsumer<? super String,? super List<String>> consumer) {
        Utils.checkNotNull(consumer, "consumer");
        map.forEach(consumer);
    }

    /**
     * Returns a copy of the headers as a map. Header names are lowercase.
     * 
     * @return headers as a map
     */
    public Map<String, List<String>> map() {
        return map //
                .entrySet() //
                .stream() //
                .collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList<>(entry.getValue())));
    }

    private List<String> values(String name) {
        return map.getOrDefault(name.toLowerCase(Locale.ENGLISH), List.of());
    }

    @Override
    public String toString() {
        return "Headers[ " //
                + map.entrySet() //
                        .stream() //
                        .map(entry -> entry.getKey() + "=" + entry.getValue()) //
                        .collect(Collectors.joining(", ")) //
                + "]";
    }
}
