/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.Blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.concurrent.CompletableFuture;

public class SpeakeasyHTTPClient implements HTTPClient {

    // global debug flag. Retained for backwards compatibility.
    private static boolean debugEnabled = false;

    // Instance-level debug flag. Can be set by clients to enable debug logging for a
    // single SDK instance.
    private Boolean localDebugEnabled;

    // uppercase
    private static Set<String> redactedHeaders = Set.of("AUTHORIZATION", "X-API-KEY");
    
    private static Consumer<? super String> logger = System.out::println;

    private final HttpClient client = HttpClient.newHttpClient();

    /**
     * Sets debug logging on or off for requests and responses including bodies for JSON content.
     * <p>
     * <strong>WARNING:</strong> This setting may expose sensitive information in logs (such as
     * {@code Authorization} headers) and should only be enabled temporarily for local debugging
     * purposes.
     * <p>
     * By default, {@code Authorization} headers are redacted in the logs (printed with a value
     * of {@code [*******]}). Header suppression can be controlled with the
     * {@link #setRedactedHeaders(Collection)} method.
     *
     * @param enabled {@code true} to enable debug logging, {@code false} to disable it
     * @see #setRedactedHeaders(Collection)
     * @see #addRedactedHeader(String)
     * @see #getDebugLoggingEnabled()
     */
    public static void setDebugLogging(boolean enabled) {
        debugEnabled = enabled;
    }

    public static boolean getDebugLoggingEnabled() {
        return debugEnabled;
    }

    @Override
    public boolean isDebugLoggingEnabled() {
        return Optional.ofNullable(localDebugEnabled).orElse(debugEnabled);
    }

    @Override
    public void enableDebugLogging(boolean enabled) {
        localDebugEnabled = enabled;
    }

    /**
     * When debug logging is enabled, this method controls the suppression of header values in the logs.
     * <p>
     * By default, {@code Authorization} headers are redacted in the logs (printed with a value
     * of {@code [*******]}).
     *
     * @param headerNames the names (case-insensitive) of the headers whose values
     *                    will be redacted in the logs
     * @see #setDebugLogging(boolean)
     */
    public static void setRedactedHeaders(Collection<String> headerNames) {
        redactedHeaders = headerNames.stream() //
                .map(x -> x.toUpperCase(Locale.ENGLISH)) //
                .collect(Collectors.toSet());
    }

    /**
     * When debug logging is enabled, this method adds a single header to the list of headers
     * whose values will be redacted in the logs.
     * <p>
     * By default, {@code Authorization} headers are redacted in the logs (printed with a value
     * of {@code [*******]}).
     * 
     * @param headerName the name (case-insensitive) of the header whose value 
     *                   will be redacted in the logs
     * @see #setDebugLogging(boolean)
     * @see #setRedactedHeaders(Collection)
     */
    public static void addRedactedHeader(String headerName) {
        Set<String> updated = new java.util.HashSet<>(redactedHeaders);
        updated.add(headerName.toUpperCase(Locale.ENGLISH));
        redactedHeaders = Set.copyOf(updated);
    }

    public static void setLogger(Consumer<? super String> logger) {
        SpeakeasyHTTPClient.logger = logger;
    }

    @Override
    public HttpResponse<InputStream> send(HttpRequest request)
            throws IOException, InterruptedException, URISyntaxException {
        if (isDebugLoggingEnabled()) {
            request = logRequest(request, true);
        }
        var response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        if (isDebugLoggingEnabled()) {
            response = logResponse(response, true);
        }
        return response;
    }

    @Override
    public CompletableFuture<HttpResponse<Blob>> sendAsync(HttpRequest request) {
        if (isDebugLoggingEnabled()) {
            request = logRequest(request, true);
        }
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofPublisher())
                .thenApply(response ->
                        // TODO: log responses when helper for Blob is setup
                        new ResponseWithBody<>(response, Blob::from));
    }

    private HttpRequest logRequest(HttpRequest request, boolean logBody) {
        log("Sending request: " + request);
        log("Request headers: " + redactHeaders(request.headers()));
        // only log the body if logBody is true and the body is present and the content type is JSON
        if (logBody && request.bodyPublisher().isPresent() && request.headers() //
                .firstValue("Content-Type") //
                .filter(x -> x.equals("application/json") || x.equals("text/plain")).isPresent()) {
            // we read the body and ensure that the BodyPublisher is rebuilt to pass to the
            // http client
            byte[] body = Helpers.bodyBytes(request);
            request = Helpers //
                    .copy(request) //
                    .method(request.method(), BodyPublishers.ofByteArray(body)) //
                    .build();
            // note that in the case of text/plain a different encoding from UTF-8
            // may be in use but we just log the bytes as UTF-8. Unexpected encodings
            // do not throw (substitution happens).
            log("Request body:\n" + new String(body, StandardCharsets.UTF_8));
        }
        return request;
    }

    private static HttpResponse<InputStream> logResponse(HttpResponse<InputStream> response, boolean logBody) throws IOException {
        String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
        log("Received response: " + response);
        log("Response headers: " + redactHeaders(response.headers()));

        // skip caching for streaming responses - they may hang
        if (contentType.startsWith("text/event-stream") || contentType.startsWith("application/x-ndjson")) {
            return response;
        }

        // make the response re-readable by loading the response body into a byte array
        // and allowing the InputStream to be read many times
        response = Utils.cache(response);

        // only log the response body if logBody is true and the content type is JSON or plain text
        if (logBody && (contentType.startsWith("application/json") || contentType.startsWith("text/plain"))) {
            // the response is re-readable so we can read and close it without
            // affecting later processing of the response.

            // note that in the case of text/plain a different encoding from UTF-8
            // may be in use but we just log the bytes as UTF-8. Unexpected encodings
            // do not throw (substitution happens).
            log("Response body:\n" + Utils.toUtf8AndClose(response.body()));
        }
        return response;
    }

    private static String redactHeaders(HttpHeaders headers) {
        return "{" + headers.map() //
                .entrySet() //
                .stream() //
                .map(entry -> {
                    final String value;
                    if (redactedHeaders.contains(entry.getKey().toUpperCase(Locale.ENGLISH))) {
                        value = "[******]";
                    } else {
                        value = String.valueOf(entry.getValue());
                    }
                    return entry.getKey() + "=" + value;
                }) //
                .collect(Collectors.joining(", ")) + "}";
    }

    private static void log(String message) {
        logger.accept(message);
    }
}
