/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class ConnectSession {

    @JsonProperty("id")
    private double id;

    @JsonProperty("organization_id")
    private double organizationId;

    @JsonProperty("project_id")
    private String projectId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("categories")
    private JsonNullable<? extends List<ConnectSessionCategories>> categories;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider")
    private JsonNullable<String> provider;

    @JsonProperty("origin_owner_id")
    private String originOwnerId;

    @JsonProperty("origin_owner_name")
    private String originOwnerName;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("origin_username")
    private JsonNullable<String> originUsername;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_id")
    private JsonNullable<String> accountId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    @JsonProperty("created_at")
    private OffsetDateTime createdAt;

    /**
     * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("metadata")
    private JsonNullable<? extends ConnectSessionMetadata> metadata;

    @JsonCreator
    public ConnectSession(
            @JsonProperty("id") double id,
            @JsonProperty("organization_id") double organizationId,
            @JsonProperty("project_id") String projectId,
            @JsonProperty("categories") JsonNullable<? extends List<ConnectSessionCategories>> categories,
            @JsonProperty("provider") JsonNullable<String> provider,
            @JsonProperty("origin_owner_id") String originOwnerId,
            @JsonProperty("origin_owner_name") String originOwnerName,
            @JsonProperty("origin_username") JsonNullable<String> originUsername,
            @JsonProperty("account_id") JsonNullable<String> accountId,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("created_at") OffsetDateTime createdAt,
            @JsonProperty("metadata") JsonNullable<? extends ConnectSessionMetadata> metadata) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(projectId, "projectId");
        Utils.checkNotNull(categories, "categories");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        Utils.checkNotNull(originUsername, "originUsername");
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(metadata, "metadata");
        this.id = id;
        this.organizationId = organizationId;
        this.projectId = projectId;
        this.categories = categories;
        this.provider = provider;
        this.originOwnerId = originOwnerId;
        this.originOwnerName = originOwnerName;
        this.originUsername = originUsername;
        this.accountId = accountId;
        this.label = label;
        this.createdAt = createdAt;
        this.metadata = metadata;
    }
    
    public ConnectSession(
            double id,
            double organizationId,
            String projectId,
            String originOwnerId,
            String originOwnerName,
            OffsetDateTime createdAt) {
        this(id, organizationId, projectId, JsonNullable.undefined(), JsonNullable.undefined(), originOwnerId, originOwnerName, JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), createdAt, JsonNullable.undefined());
    }

    @JsonIgnore
    public double id() {
        return id;
    }

    @JsonIgnore
    public double organizationId() {
        return organizationId;
    }

    @JsonIgnore
    public String projectId() {
        return projectId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ConnectSessionCategories>> categories() {
        return (JsonNullable<List<ConnectSessionCategories>>) categories;
    }

    @JsonIgnore
    public JsonNullable<String> provider() {
        return provider;
    }

    @JsonIgnore
    public String originOwnerId() {
        return originOwnerId;
    }

    @JsonIgnore
    public String originOwnerName() {
        return originOwnerName;
    }

    @JsonIgnore
    public JsonNullable<String> originUsername() {
        return originUsername;
    }

    @JsonIgnore
    public JsonNullable<String> accountId() {
        return accountId;
    }

    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    @JsonIgnore
    public OffsetDateTime createdAt() {
        return createdAt;
    }

    /**
     * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ConnectSessionMetadata> metadata() {
        return (JsonNullable<ConnectSessionMetadata>) metadata;
    }

    public final static Builder builder() {
        return new Builder();
    }

    public ConnectSession withId(double id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public ConnectSession withOrganizationId(double organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public ConnectSession withProjectId(String projectId) {
        Utils.checkNotNull(projectId, "projectId");
        this.projectId = projectId;
        return this;
    }

    public ConnectSession withCategories(List<ConnectSessionCategories> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = JsonNullable.of(categories);
        return this;
    }

    public ConnectSession withCategories(JsonNullable<? extends List<ConnectSessionCategories>> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = categories;
        return this;
    }

    public ConnectSession withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = JsonNullable.of(provider);
        return this;
    }

    public ConnectSession withProvider(JsonNullable<String> provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public ConnectSession withOriginOwnerId(String originOwnerId) {
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        this.originOwnerId = originOwnerId;
        return this;
    }

    public ConnectSession withOriginOwnerName(String originOwnerName) {
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        this.originOwnerName = originOwnerName;
        return this;
    }

    public ConnectSession withOriginUsername(String originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = JsonNullable.of(originUsername);
        return this;
    }

    public ConnectSession withOriginUsername(JsonNullable<String> originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = originUsername;
        return this;
    }

    public ConnectSession withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = JsonNullable.of(accountId);
        return this;
    }

    public ConnectSession withAccountId(JsonNullable<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public ConnectSession withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    public ConnectSession withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    public ConnectSession withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
     */
    public ConnectSession withMetadata(ConnectSessionMetadata metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = JsonNullable.of(metadata);
        return this;
    }

    /**
     * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
     */
    public ConnectSession withMetadata(JsonNullable<? extends ConnectSessionMetadata> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ConnectSession other = (ConnectSession) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.organizationId, other.organizationId) &&
            Objects.deepEquals(this.projectId, other.projectId) &&
            Objects.deepEquals(this.categories, other.categories) &&
            Objects.deepEquals(this.provider, other.provider) &&
            Objects.deepEquals(this.originOwnerId, other.originOwnerId) &&
            Objects.deepEquals(this.originOwnerName, other.originOwnerName) &&
            Objects.deepEquals(this.originUsername, other.originUsername) &&
            Objects.deepEquals(this.accountId, other.accountId) &&
            Objects.deepEquals(this.label, other.label) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.metadata, other.metadata);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            organizationId,
            projectId,
            categories,
            provider,
            originOwnerId,
            originOwnerName,
            originUsername,
            accountId,
            label,
            createdAt,
            metadata);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ConnectSession.class,
                "id", id,
                "organizationId", organizationId,
                "projectId", projectId,
                "categories", categories,
                "provider", provider,
                "originOwnerId", originOwnerId,
                "originOwnerName", originOwnerName,
                "originUsername", originUsername,
                "accountId", accountId,
                "label", label,
                "createdAt", createdAt,
                "metadata", metadata);
    }
    
    public final static class Builder {
 
        private Double id;
 
        private Double organizationId;
 
        private String projectId;
 
        private JsonNullable<? extends List<ConnectSessionCategories>> categories = JsonNullable.undefined();
 
        private JsonNullable<String> provider = JsonNullable.undefined();
 
        private String originOwnerId;
 
        private String originOwnerName;
 
        private JsonNullable<String> originUsername = JsonNullable.undefined();
 
        private JsonNullable<String> accountId = JsonNullable.undefined();
 
        private JsonNullable<String> label = JsonNullable.undefined();
 
        private OffsetDateTime createdAt;
 
        private JsonNullable<? extends ConnectSessionMetadata> metadata = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder id(double id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder organizationId(double organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder projectId(String projectId) {
            Utils.checkNotNull(projectId, "projectId");
            this.projectId = projectId;
            return this;
        }

        public Builder categories(List<ConnectSessionCategories> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = JsonNullable.of(categories);
            return this;
        }

        public Builder categories(JsonNullable<? extends List<ConnectSessionCategories>> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = categories;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = JsonNullable.of(provider);
            return this;
        }

        public Builder provider(JsonNullable<String> provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder originOwnerId(String originOwnerId) {
            Utils.checkNotNull(originOwnerId, "originOwnerId");
            this.originOwnerId = originOwnerId;
            return this;
        }

        public Builder originOwnerName(String originOwnerName) {
            Utils.checkNotNull(originOwnerName, "originOwnerName");
            this.originOwnerName = originOwnerName;
            return this;
        }

        public Builder originUsername(String originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = JsonNullable.of(originUsername);
            return this;
        }

        public Builder originUsername(JsonNullable<String> originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = originUsername;
            return this;
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = JsonNullable.of(accountId);
            return this;
        }

        public Builder accountId(JsonNullable<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
         */
        public Builder metadata(ConnectSessionMetadata metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = JsonNullable.of(metadata);
            return this;
        }

        /**
         * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
         */
        public Builder metadata(JsonNullable<? extends ConnectSessionMetadata> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }
        
        public ConnectSession build() {
            return new ConnectSession(
                id,
                organizationId,
                projectId,
                categories,
                provider,
                originOwnerId,
                originOwnerName,
                originUsername,
                accountId,
                label,
                createdAt,
                metadata);
        }
    }
}

