/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class HRISTeamValue {
    public static final HRISTeamValue TEAM = new HRISTeamValue("team");
    private static final Map<String, HRISTeamValue> values = HRISTeamValue.createValuesMap();
    private static final Map<String, HRISTeamValueEnum> enums = HRISTeamValue.createEnumsMap();
    private final String value;

    private HRISTeamValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISTeamValue of(String value) {
        Class<HRISTeamValue> clazz = HRISTeamValue.class;
        synchronized (HRISTeamValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HRISTeamValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<HRISTeamValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HRISTeamValue other = (HRISTeamValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HRISTeamValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISTeamValue[] values() {
        Class<HRISTeamValue> clazz = HRISTeamValue.class;
        synchronized (HRISTeamValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HRISTeamValue[0]);
        }
    }

    private static final Map<String, HRISTeamValue> createValuesMap() {
        LinkedHashMap<String, HRISTeamValue> map = new LinkedHashMap<String, HRISTeamValue>();
        map.put("team", TEAM);
        return map;
    }

    private static final Map<String, HRISTeamValueEnum> createEnumsMap() {
        HashMap<String, HRISTeamValueEnum> map = new HashMap<String, HRISTeamValueEnum>();
        map.put("team", HRISTeamValueEnum.TEAM);
        return map;
    }

    public static enum HRISTeamValueEnum {
        TEAM("team");

        private final String value;

        private HRISTeamValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<HRISTeamValue> {
        protected _Deserializer() {
            super(HRISTeamValue.class);
        }

        public HRISTeamValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return HRISTeamValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<HRISTeamValue> {
        protected _Serializer() {
            super(HRISTeamValue.class);
        }

        public void serialize(HRISTeamValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

