/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.LocalizationModelLanguage;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class LocalizationModel {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="title")
    private JsonNullable<String> title;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="description")
    private JsonNullable<String> description;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="language")
    private JsonNullable<? extends LocalizationModelLanguage> language;

    @JsonCreator
    public LocalizationModel(@JsonProperty(value="title") JsonNullable<String> title, @JsonProperty(value="description") JsonNullable<String> description, @JsonProperty(value="language") JsonNullable<? extends LocalizationModelLanguage> language) {
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(language, "language");
        this.title = title;
        this.description = description;
        this.language = language;
    }

    public LocalizationModel() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends LocalizationModelLanguage>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> title() {
        return this.title;
    }

    @JsonIgnore
    public JsonNullable<String> description() {
        return this.description;
    }

    @JsonIgnore
    public JsonNullable<LocalizationModelLanguage> language() {
        return this.language;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LocalizationModel withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of((Object)title);
        return this;
    }

    public LocalizationModel withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    public LocalizationModel withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    public LocalizationModel withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public LocalizationModel withLanguage(LocalizationModelLanguage language) {
        Utils.checkNotNull(language, "language");
        this.language = JsonNullable.of((Object)language);
        return this;
    }

    public LocalizationModel withLanguage(JsonNullable<? extends LocalizationModelLanguage> language) {
        Utils.checkNotNull(language, "language");
        this.language = language;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizationModel other = (LocalizationModel)o;
        return Objects.deepEquals(this.title, other.title) && Objects.deepEquals(this.description, other.description) && Objects.deepEquals(this.language, other.language);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.language);
    }

    public String toString() {
        return Utils.toString(LocalizationModel.class, "title", this.title, "description", this.description, "language", this.language);
    }

    public static final class Builder {
        private JsonNullable<String> title = JsonNullable.undefined();
        private JsonNullable<String> description = JsonNullable.undefined();
        private JsonNullable<? extends LocalizationModelLanguage> language = JsonNullable.undefined();

        private Builder() {
        }

        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of((Object)title);
            return this;
        }

        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of((Object)description);
            return this;
        }

        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        public Builder language(LocalizationModelLanguage language) {
            Utils.checkNotNull(language, "language");
            this.language = JsonNullable.of((Object)language);
            return this;
        }

        public Builder language(JsonNullable<? extends LocalizationModelLanguage> language) {
            Utils.checkNotNull(language, "language");
            this.language = language;
            return this;
        }

        public LocalizationModel build() {
            return new LocalizationModel(this.title, this.description, this.language);
        }
    }
}

