/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestResponse;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneProxyRequestRequestBuilder {
    private String xAccountId;
    private ProxyRequestBody proxyRequestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallStackoneProxyRequest sdk;

    public StackoneProxyRequestRequestBuilder(SDKMethodInterfaces.MethodCallStackoneProxyRequest sdk) {
        this.sdk = sdk;
    }

    public StackoneProxyRequestRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneProxyRequestRequestBuilder proxyRequestBody(ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.proxyRequestBody = proxyRequestBody;
        return this;
    }

    public StackoneProxyRequestRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneProxyRequestRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public StackoneProxyRequestResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.proxyRequest(this.xAccountId, this.proxyRequestBody, options);
    }
}

